<?php
/**
 * @package   AkeebaSocialLogin
 * @copyright Copyright (c)2016-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Plugin\Sociallogin\Spotify\Extension;

defined('_JEXEC') || die();

use Akeeba\Plugin\Sociallogin\Spotify\Integration\OAuth as SpotifyOAuth;
use Akeeba\Plugin\Sociallogin\Spotify\Integration\UserQuery;
use Akeeba\Plugin\System\SocialLogin\Library\Data\UserData;
use Akeeba\Plugin\System\SocialLogin\Library\Plugin\AbstractPlugin;
use Joomla\CMS\Uri\Uri;
use Joomla\Http\HttpFactory;
use Joomla\Registry\Registry;

if (!class_exists(AbstractPlugin::class, true))
{
	return;
}

class Plugin extends AbstractPlugin
{

	public static function getSubscribedEvents(): array
	{
		return array_merge(parent::getSubscribedEvents(), ['onAjaxSpotify' => 'onSocialLoginAjax']);
	}

	public function init(): void
	{
		$this->fgColor = '';
		$this->bgColor = '';
		parent::init();
		$this->buttonImage = 'plg_sociallogin_spotify/spotify.png';
	}

	protected function getConnector(): SpotifyOAuth
	{
		if (is_null($this->connector))
		{
			$options         = [
				'clientid'      => $this->appId,
				'clientsecret'  => $this->appSecret,
				'redirecturi'   => Uri::base() . 'index.php?option=com_ajax&group=sociallogin&plugin='
				                   . $this->integrationName . '&format=raw',
				'requestparams' => ['state' => $this->getApplication()->getSession()->getToken()],
			];
			$httpClient      = (new HttpFactory())->getHttp();
			$this->connector = new SpotifyOAuth(
				$options, $httpClient, $this->getapplication()->getInput(), $this->getApplication()
			);
			$this->connector->setScope('user-read-email');
		}

		return $this->connector;
	}

	protected function getSocialNetworkProfileInformation(object $connector): ?array
	{
		try
		{
			$tokenArray  = $connector->getToken();
			$options     = new Registry(['userAgent' => 'Akeeba-Social-Login']);
			$client      = (new HttpFactory())->getHttp($options);
			$dUserQuery  = new UserQuery($client, $tokenArray['access_token']);
			$dUserFields = $dUserQuery->getUserInformation();

			return (array) $dUserFields;
		}
		catch (\Throwable $e)
		{
			return null;
		}
	}

	protected function mapSocialProfileToUserData(array $socialProfile): UserData
	{
		$userData           = new UserData();
		$userData->name     = $socialProfile['display_name'] ?? '';
		$userData->id       = $socialProfile['id'] ?? '';
		$userData->email    = $socialProfile['email'] ?? '';
		$userData->verified = true;

		return $userData;
	}

}