<?php
/**
 * @package   AkeebaSocialLogin
 * @copyright Copyright (c)2016-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Plugin\Sociallogin\Apple\Util;

defined('_JEXEC') || die;

/**
 * Generates random adjective-noun pairs.
 *
 * We use this to create random usernames when full name information is not provided by Apple for any reason.
 *
 * @since   3.2.0
 */
class RandomWords
{
	/**
	 * A list of non-offensive, English adjectives
	 *
	 * @since 3.2.0
	 * @var   string[]
	 */
	private static array $adjectives = [
		"additional",
		"administrative",
		"adorable",
		"adult",
		"aesthetic",
		"after",
		"airy",
		"alive",
		"alternative",
		"amazing",
		"amethyst",
		"ancient",
		"annual",
		"another",
		"aqua",
		"automatic",
		"available",
		"aware",
		"basic",
		"beautiful",
		"beginning",
		"best",
		"better",
		"big",
		"blissful",
		"bold",
		"brave",
		"brief",
		"bright",
		"brilliant",
		"business",
		"calm",
		"capable",
		"careful",
		"certain",
		"cerulean",
		"charming",
		"chemical",
		"civil",
		"classic",
		"clear",
		"close",
		"colorful",
		"comfortable",
		"commercial",
		"common",
		"competitive",
		"complete",
		"complex",
		"comprehensive",
		"confident",
		"conscious",
		"consistent",
		"constant",
		"cool",
		"crazy",
		"creative",
		"crimson",
		"critical",
		"cultural",
		"curious",
		"current",
		"cute",
		"dark",
		"dear",
		"decent",
		"delightful",
		"dependent",
		"different",
		"direct",
		"distinct",
		"downtown",
		"easy",
		"economy",
		"educational",
		"effective",
		"either",
		"electronic",
		"emerald",
		"enchanted",
		"environmental",
		"epic",
		"equal",
		"even",
		"every",
		"exact",
		"excellent",
		"exciting",
		"existing",
		"expensive",
		"external",
		"extra",
		"extreme",
		"fair",
		"false",
		"familiar",
		"famous",
		"fantastical",
		"fast",
		"federal",
		"female",
		"final",
		"financial",
		"flat",
		"flawless",
		"foreign",
		"formal",
		"former",
		"free",
		"fresh",
		"friendly",
		"full",
		"funny",
		"future",
		"gargantuan",
		"general",
		"glittery",
		"global",
		"glorious",
		"golden",
		"good",
		"graceful",
		"grand",
		"great",
		"green",
		"guilty",
		"happy",
		"hard",
		"head",
		"healthy",
		"heavy",
		"helpful",
		"historical",
		"home",
		"honest",
		"hot",
		"human",
		"hungry",
		"imaginary",
		"immediate",
		"important",
		"impressive",
		"incredible",
		"independent",
		"individual",
		"informal",
		"initial",
		"inspirational",
		"intelligent",
		"interesting",
		"internal",
		"international",
		"junior",
		"key",
		"kind",
		"known",
		"last",
		"late",
		"lavish",
		"leading",
		"least",
		"legendary",
		"less",
		"level",
		"light",
		"limpid",
		"little",
		"logical",
		"loud",
		"lucid",
		"lucky",
		"luminous",
		"lunar",
		"majestic",
		"major",
		"many",
		"massive",
		"medical",
		"memorable",
		"middle",
		"mobile",
		"mystical",
		"mythical",
		"narrow",
		"national",
		"natural",
		"nearby",
		"neat",
		"necessary",
		"new",
		"nice",
		"normal",
		"numerous",
		"objective",
		"obsidian",
		"obvious",
		"official",
		"open",
		"ordinary",
		"original",
		"particular",
		"pastel",
		"perfect",
		"personal",
		"picturesque",
		"pleasant",
		"political",
		"popular",
		"positive",
		"potential",
		"powerful",
		"practical",
		"present",
		"pretty",
		"previous",
		"primary",
		"private",
		"professional",
		"proper",
		"proud",
		"public",
		"pure",
		"quick",
		"quiet",
		"radiant",
		"rare",
		"real",
		"realistic",
		"reasonable",
		"recent",
		"relevant",
		"remarkable",
		"representative",
		"responsible",
		"rich",
		"right",
		"royal",
		"ruby",
		"safe",
		"same",
		"sapphire",
		"secret",
		"secure",
		"sensitive",
		"serene",
		"serious",
		"sharp",
		"shimmering",
		"shiny",
		"significant",
		"silver",
		"simple",
		"slight",
		"smart",
		"smooth",
		"soft",
		"solar",
		"southern",
		"spare",
		"special",
		"spiritual",
		"stellar",
		"straight",
		"strict",
		"strong",
		"successful",
		"suitable",
		"super",
		"sure",
		"suspicious",
		"sweet",
		"tall",
		"technical",
		"tiny",
		"tough",
		"traditional",
		"true",
		"uncommon",
		"unique",
		"used",
		"useful",
		"valuable",
		"various",
		"vast",
		"vibrant",
		"visible",
		"vivacious",
		"warm",
		"whimsical",
		"wise",
		"wonderful",
		"wonderous",
		"wooden",
		"working",
		"young",
	];

	/**
	 * A list of non-offensive, English nouns
	 *
	 * @since 3.2.0
	 * @var   string[]
	 */
	private static array $nouns = [
		"ability",
		"accident",
		"activity",
		"actor",
		"ad",
		"addition",
		"administration",
		"advertising",
		"advice",
		"affair",
		"agency",
		"agreement",
		"airport",
		"alcohol",
		"alpaca",
		"ambition",
		"analysis",
		"analyst",
		"anemone",
		"anxiety",
		"apartment",
		"appearance",
		"apple",
		"application",
		"appointment",
		"area",
		"argument",
		"army",
		"arrival",
		"art",
		"article",
		"aspect",
		"assignment",
		"assistance",
		"assistant",
		"association",
		"assumption",
		"atmosphere",
		"attention",
		"attitude",
		"audience",
		"awareness",
		"bamboo",
		"baseball",
		"basis",
		"basket",
		"bath",
		"bathroom",
		"bear",
		"bedroom",
		"beer",
		"bird",
		"birthday",
		"blossom",
		"bonus",
		"bread",
		"breath",
		"brook",
		"buyer",
		"cabinet",
		"camera",
		"candidate",
		"canopy",
		"castle",
		"category",
		"celebration",
		"championship",
		"chapter",
		"charity",
		"cheek",
		"chemistry",
		"chest",
		"child",
		"childhood",
		"chocolate",
		"church",
		"city",
		"classroom",
		"client",
		"climate",
		"clothes",
		"coffee",
		"collection",
		"college",
		"combination",
		"committee",
		"communication",
		"community",
		"comparison",
		"competition",
		"complaint",
		"computer",
		"concept",
		"conclusion",
		"connection",
		"consequence",
		"construction",
		"context",
		"contract",
		"contribution",
		"control",
		"conversation",
		"cookie",
		"cottage",
		"country",
		"county",
		"courage",
		"cousin",
		"criticism",
		"crystal",
		"currency",
		"customer",
		"dad",
		"data",
		"database",
		"decision",
		"definition",
		"delivery",
		"department",
		"departure",
		"depression",
		"depth",
		"description",
		"desk",
		"development",
		"device",
		"diamond",
		"difference",
		"dinner",
		"dinosaur",
		"direction",
		"director",
		"dirt",
		"discussion",
		"disk",
		"distribution",
		"dragon",
		"drawer",
		"drawing",
		"driver",
		"ear",
		"eclipse",
		"economics",
		"editor",
		"education",
		"efficiency",
		"effort",
		"election",
		"elephant",
		"elevator",
		"emotion",
		"emphasis",
		"employee",
		"employer",
		"employment",
		"energy",
		"engine",
		"engineering",
		"entertainment",
		"enthusiasm",
		"entry",
		"environment",
		"equipment",
		"establishment",
		"estate",
		"event",
		"exam",
		"examination",
		"excitement",
		"explanation",
		"expression",
		"extent",
		"fable",
		"fact",
		"falcon",
		"family",
		"farmer",
		"feedback",
		"ferret",
		"field",
		"finding",
		"firefly",
		"fishing",
		"flamingo",
		"flight",
		"food",
		"football",
		"forest",
		"fortune",
		"foundation",
		"fox",
		"freedom",
		"friendship",
		"funeral",
		"garbage",
		"garden",
		"gate",
		"gem",
		"gene",
		"giraffe",
		"goal",
		"government",
		"grandmother",
		"grocery",
		"growth",
		"gryffin",
		"guest",
		"guidance",
		"guitar",
		"hair",
		"hall",
		"hare",
		"hat",
		"health",
		"hearing",
		"heart",
		"hedgehog",
		"height",
		"highway",
		"hippo",
		"historian",
		"history",
		"homework",
		"honey",
		"hotel",
		"housing",
		"iceburg",
		"idea",
		"iguana",
		"illusion",
		"imagination",
		"importance",
		"impression",
		"improvement",
		"income",
		"independence",
		"indication",
		"industry",
		"information",
		"initiative",
		"inspection",
		"instance",
		"instruction",
		"insurance",
		"intention",
		"interaction",
		"internet",
		"introduction",
		"investment",
		"island",
		"jackalope",
		"judgment",
		"king",
		"kingdom",
		"knowledge",
		"koi",
		"lab",
		"ladder",
		"lady",
		"lake",
		"language",
		"law",
		"leader",
		"leadership",
		"lemur",
		"length",
		"library",
		"lion",
		"literature",
		"lizard",
		"llama",
		"location",
		"loss",
		"love",
		"lynx",
		"magazine",
		"maintenance",
		"mall",
		"management",
		"manager",
		"manufacturer",
		"map",
		"marketing",
		"marmoset",
		"marriage",
		"math",
		"meadow",
		"meal",
		"meaning",
		"measurement",
		"meat",
		"media",
		"medicine",
		"meerkat",
		"member",
		"membership",
		"memory",
		"menu",
		"message",
		"method",
		"midnight",
		"mixture",
		"mode",
		"mom",
		"moment",
		"month",
		"mood",
		"moon",
		"movie",
		"music",
		"narwhal",
		"nation",
		"nature",
		"negotiation",
		"news",
		"newspaper",
		"night",
		"nova",
		"oasis",
		"obligation",
		"office",
		"operation",
		"opinion",
		"opportunity",
		"orange",
		"organization",
		"oryx",
		"outcome",
		"oven",
		"owner",
		"painting",
		"paper",
		"passenger",
		"passion",
		"patience",
		"payment",
		"penalty",
		"penguin",
		"people",
		"percentage",
		"perception",
		"performance",
		"permission",
		"person",
		"personality",
		"perspective",
		"philosophy",
		"phoenix",
		"phone",
		"photo",
		"physics",
		"piano",
		"pie",
		"pizza",
		"platform",
		"player",
		"poem",
		"poet",
		"poetry",
		"police",
		"politics",
		"pollution",
		"population",
		"possession",
		"possibility",
		"potato",
		"power",
		"preference",
		"preparation",
		"presence",
		"presentation",
		"president",
		"priority",
		"problem",
		"procedure",
		"product",
		"profession",
		"professor",
		"promotion",
		"property",
		"proposal",
		"protection",
		"psychology",
		"pyramid",
		"quality",
		"quantity",
		"queen",
		"ratio",
		"reaction",
		"reading",
		"reality",
		"reception",
		"recipe",
		"recognition",
		"recommendation",
		"recording",
		"reef",
		"reflection",
		"refrigerator",
		"region",
		"relation",
		"relationship",
		"replacement",
		"republic",
		"reputation",
		"requirement",
		"resolution",
		"resource",
		"response",
		"responsibility",
		"restaurant",
		"revenue",
		"revolution",
		"rhino",
		"river",
		"road",
		"role",
		"safety",
		"salad",
		"salamander",
		"sample",
		"sapling",
		"satisfaction",
		"scene",
		"science",
		"secretary",
		"security",
		"selection",
		"series",
		"session",
		"setting",
		"shark",
		"shirt",
		"shopping",
		"shrine",
		"signature",
		"significance",
		"singer",
		"situation",
		"skill",
		"skyline",
		"sloth",
		"society",
		"software",
		"solution",
		"song",
		"soup",
		"speaker",
		"speech",
		"spirit",
		"squirrel",
		"star",
		"statement",
		"steak",
		"stone",
		"storage",
		"storm",
		"story",
		"strategy",
		"student",
		"studio",
		"success",
		"suggestion",
		"summit",
		"sunrise",
		"sunset",
		"supermarket",
		"surgery",
		"sympathy",
		"system",
		"tale",
		"teacher",
		"technology",
		"television",
		"temperature",
		"temple",
		"tennis",
		"tension",
		"theory",
		"thing",
		"thought",
		"tiger",
		"tome",
		"tongue",
		"tooth",
		"topic",
		"tower",
		"town",
		"tradition",
		"trail",
		"trainer",
		"transportation",
		"truth",
		"turtle",
		"twilight",
		"two",
		"understanding",
		"unicorn",
		"unit",
		"university",
		"user",
		"valley",
		"variation",
		"variety",
		"vehicle",
		"version",
		"video",
		"village",
		"volume",
		"warning",
		"waterfall",
		"weakness",
		"wealth",
		"wedding",
		"week",
		"whale",
		"winner",
		"wood",
		"worker",
		"world",
		"writer",
		"writing",
		"year",
		"yeti",
		"youth",
	];

	/**
	 * A random adjective-noun pair
	 *
	 * @return  array  As ['adjective', 'noun']
	 * @since   3.2.0
	 */
	public static function randomPair(): array
	{
		[$usec, $sec] = microtime(false);
		$seed = $sec + $usec * 1000000;
		mt_srand($seed, MT_RAND_MT19937);

		return [
			self::$adjectives[random_int(0, count(self::$adjectives) - 1)],
			self::$nouns[random_int(0, count(self::$nouns) - 1)],
		];
	}
}
