<?php
/**
 * @package   akeebabackup
 * @copyright Copyright (c)2006-2024 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Akeeba\Plugin\QuickIcon\AkeebaBackup\Extension\AkeebaBackup;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;

return new class implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   9.0.0
	 */
	public function register(Container $container)
	{
		$container->registerServiceProvider(new MVCFactory('Akeeba\\Component\\AkeebaBackup'));

		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$config     = (array) PluginHelper::getPlugin('quickicon', 'akeebabackup');
				$dispatcher = $container->get(DispatcherInterface::class);

				$plugin = version_compare(JVERSION, '5.4.0', 'ge')
					? new AkeebaBackup($config)
					: new AkeebaBackup(
						$dispatcher, $config
					);

				$plugin->setDocument(Factory::getApplication()->getDocument());
				$plugin->setMVCFactory($container->get(MVCFactoryInterface::class));
				$plugin->setApplication(Factory::getApplication());
				$plugin->setDatabase($container->get(\Joomla\Database\DatabaseInterface::class));

				return $plugin;
			}
		);
	}
};
