<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Module\Atsgraphs\Administrator\Dispatcher;

defined('_JEXEC') or die;

use DateInterval;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Document\HtmlDocument;
use Joomla\CMS\Extension\ModuleInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Input\Input;

class Dispatcher extends AbstractModuleDispatcher
{
	/**
	 * The module extension. Used to fetch the module helper.
	 *
	 * @var   ModuleInterface|null
	 * @since 5.0.0
	 */
	private $moduleExtension;

	/** @inheritdoc */
	public function __construct(\stdClass $module, CMSApplicationInterface $app, Input $input)
	{
		parent::__construct($module, $app, $input);

		$this->moduleExtension = $this->app->bootModule('mod_atsgraphs', 'administrator');
	}

	/** @inheritdoc */
	protected function getLayoutData()
	{
		$hasAts = ComponentHelper::isInstalled('com_ats') && ComponentHelper::isEnabled('com_ats');

		if ($hasAts)
		{
			$this->app->getLanguage()->load('com_ats', JPATH_ADMINISTRATOR);

			/** @var HtmlDocument $document */
			$document        = $this->app->getDocument();
			$webAssetManager = $document->getWebAssetManager();

			// DO NOT REMOVE — This registers the component's Web Asset Manager stuff
			$webAssetManager->getRegistry()->addExtensionRegistryFile('com_ats');
			$webAssetManager
				->useScript('com_ats.controlpanel');

			$earliestDate = (clone Factory::getDate())->sub(new DateInterval('P1M'))->setTime(0, 0, 0, 0);

			$document->addScriptOptions('atsGraphs', [
				'ajaxUrl' => Route::_('index.php?option=com_ats&task=Controlpanel.getTicketStats&format=json', false, Route::TLS_IGNORE, true),
				'since'   => $earliestDate->toISO8601(),
			]);
		}

		return array_merge(parent::getLayoutData(), [
			'hasAts' => $hasAts,
		]);
	}

}