<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Input\Input;
use Joomla\Registry\Registry;

/**
 * These variables are extracted from the indexed array returned by the
 * \Joomla\Module\Atsgraphs\Administrator\Dispatcher\Dispatcher::getLayoutData() method.
 *
 * @var stdClass                 $module   The module data loaded by Joomla
 * @var AdministratorApplication $app      The Joomla administrator application object
 * @var Input                    $input    The application input object
 * @var Registry                 $params   The module parameters
 * @var stdClass                 $template The current admin template
 * @var bool                     $hasAts   Is ATS installed and enabled?
 *
 * @see \Akeeba\Module\Atsgraphs\Administrator\Dispatcher\Dispatcher::getLayoutData()
 */

?>
<?php // Display a message if com_ats is unpublished or not installed. ?>
<?php if (!$hasAts): ?>
	<div class="alert alert-danger">
		<h4 class="alert-header">
			<?= Text::_('MOD_ATSGRAPHS_ERR_ATSMISSING_HEAD') ?>
		</h4>
		<p>
			<?= Text::_('MOD_ATSGRAPHS_ERR_ATSMISSING_BODY') ?>
		</p>
	</div>
<?php else: ?>
	<div id="akthrobber">
		<div class="border bg-light w-100 h1 d-flex justify-content-center align-items-center" style="aspect-ratio: 4/3;">
			<?= HTMLHelper::_('image', 'com_ats/throbber.gif', '', [
				'aria-hidden' => 'true',
				'width' => 16,
				'height' => 16,
				'class' => 'm-2'
			], true) ?>
			<span>
			<?= Text::_('COM_ATS_CONTROLPANEL_LBL_LOADING_GRAPHS') ?>
		</span>
		</div>
	</div>
	<canvas id="akticketschartCanvas" class="w-100" style="aspect-ratio: 4/3;"></canvas>
<?php endif; ?>