<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Module\Atsstats\Administrator\Dispatcher;

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Extension\ModuleInterface;
use Joomla\Input\Input;
use Akeeba\Module\Atsstats\Administrator\Helper\AtsStatsHelper;

class Dispatcher extends AbstractModuleDispatcher
{
	/**
	 * The module extension. Used to fetch the module helper.
	 *
	 * @var   ModuleInterface|null
	 * @since 5.0.0
	 */
	private $moduleExtension;

	/** @inheritdoc */
	public function __construct(\stdClass $module, CMSApplicationInterface $app, Input $input)
	{
		parent::__construct($module, $app, $input);

		$this->moduleExtension = $this->app->bootModule('mod_atsstats', 'administrator');
	}

	/** @inheritdoc */
	protected function getLayoutData()
	{
		/** @var AtsStatsHelper $helper */
		$helper = $this->moduleExtension->getHelper('AtsStatsHelper');
		$hasAts = $helper->hasAts();

		if ($hasAts)
		{
			$this->app->getLanguage()->load('com_ats', JPATH_ADMINISTRATOR);
		}

		return array_merge(parent::getLayoutData(), [
			'hasAts' => $hasAts,
			'stats'  => $helper->getStatistics(),
		]);
	}

}