<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Module\Atsstats\Administrator\Helper;

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Akeeba\Component\ATS\Administrator\Model\ControlpanelModel;
use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;

defined('_JEXEC') or die;

class AtsStatsHelper
{
	/**
	 * Get the ticket statistics
	 *
	 * @return  int[]  An indexed array of ticket staistics
	 *
	 * @throws  Exception
	 * @since   5.0.0
	 */
	public function getStatistics(): array
	{
		if (!$this->hasAts())
		{
			return [
				'openPublic'     => 0,
				'pendingPublic'  => 0,
				'closedPublic'   => 0,
				'totalPublic'    => 0,
				'openPrivate'    => 0,
				'pendingPrivate' => 0,
				'closedPrivate'  => 0,
				'totalPrivate'   => 0,
				'openTotal'      => 0,
				'pendingTotal'   => 0,
				'closedTotal'    => 0,
				'totalTotal'     => 0,
			];
		}

		/** @var MVCFactoryInterface $mvcFactory */
		$mvcFactory = Factory::getApplication()->bootComponent('com_ats')->getMVCFactory();
		/** @var ControlpanelModel $model */
		$model = $mvcFactory->createModel('Controlpanel', 'administrator');

		$pendingStatuses = array_values(array_diff(array_keys(Permissions::getStatuses()), ['O', 'C']));
		$openPublic      = $model->countTickets(true, ['O']);
		$pendingPublic   = $model->countTickets(true, $pendingStatuses);
		$closedPublic    = $model->countTickets(true, ['C']);
		$openPrivate     = $model->countTickets(false, ['O']);
		$pendingPrivate  = $model->countTickets(false, $pendingStatuses);
		$closedPrivate   = $model->countTickets(false, ['C']);
		$totalPublic     = $openPublic + $pendingPublic + $closedPublic;
		$totalPrivate    = $openPrivate + $pendingPrivate + $closedPrivate;

		return [
			'openPublic'     => $openPublic,
			'pendingPublic'  => $pendingPublic,
			'closedPublic'   => $closedPublic,
			'totalPublic'    => $totalPublic,
			'openPrivate'    => $openPrivate,
			'pendingPrivate' => $pendingPrivate,
			'closedPrivate'  => $closedPrivate,
			'totalPrivate'   => $totalPrivate,
			'openTotal'      => $openPublic + $openPrivate,
			'pendingTotal'   => $pendingPublic + $pendingPrivate,
			'closedTotal'    => $closedPublic + $closedPrivate,
			'totalTotal'     => $totalPublic + $totalPrivate,
		];
	}

	/**
	 * Is the Akeeba Ticket System component installed and enabled?
	 *
	 * @return bool
	 *
	 * @since  5.0.0
	 */
	public function hasAts(): bool
	{
		return ComponentHelper::isInstalled('com_ats') && ComponentHelper::isEnabled('com_ats');
	}
}