<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\Input\Input;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;

/**
 * These variables are extracted from the indexed array returned by the
 * \Joomla\Module\Atsstats\Administrator\Dispatcher\Dispatcher::getLayoutData() method.
 *
 * @var stdClass                 $module   The module data loaded by Joomla
 * @var AdministratorApplication $app      The Joomla administrator application object
 * @var Input                    $input    The application input object
 * @var Registry                 $params   The module parameters
 * @var stdClass                 $template The current admin template
 * @var bool                     $hasAts   Is ATS installed and enabled?
 * @var array                    $stats    The ticket statistics to display
 *
 * @see \Akeeba\Module\Atsstats\Administrator\Dispatcher\Dispatcher::getLayoutData()
 */

?>
<?php // Display a message if com_ats is unpublished or not installed. ?>
<?php if (!$hasAts): ?>
	<div class="alert alert-danger">
		<h4 class="alert-header">
			<?= Text::_('MOD_ATSSTATS_ERR_ATSMISSING_HEAD') ?>
		</h4>
		<p>
			<?= Text::_('MOD_ATSSTATS_ERR_ATSMISSING_BODY') ?>
		</p>
	</div>
<?php else: ?>
	<?php // Display the ticket statistics. ?>
	<table class="table table-hover table-responsive">
		<caption>
			<?= Text::_('COM_ATS_CPANEL_STATS') ?>
		</caption>
		<thead>
		<tr>
			<td>&nbsp;</td>
			<th scope="col">
				<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=O') ?>">
					<?= Text::_('COM_ATS_TICKETS_STATUS_O') ?>
				</a>
			</th>
			<th scope="col">
				<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=P') ?>">
					<?= Text::_('COM_ATS_TICKETS_STATUS_P') ?>
				</a>
			</th>
			<th scope="col">
				<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=C') ?>">
					<?= Text::_('COM_ATS_TICKETS_STATUS_C') ?>
				</a>
			</th>
			<th scope="col">
				<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=') ?>">
					<?= Text::_('COM_ATS_TICKETS_STATUS_TOTAL') ?>
				</a>
			</th>
		</tr>
		</thead>
		<tbody>
		<tr>
			<th scope="row">
				<?= Text::_('COM_ATS_TICKETS_PUBLIC_PUBLIC') ?>
			</th>
			<td>
				<?= $stats['openPublic'] ?>
			</td>
			<td>
				<?= $stats['pendingPublic'] ?>
			</td>
			<td>
				<?= $stats['closedPublic'] ?>
			</td>
			<td class="fw-bold">
				<?= $stats['totalPublic'] ?>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<?= Text::_('COM_ATS_TICKETS_PUBLIC_PRIVATE') ?>
			</th>
			<td>
				<?= $stats['openPrivate'] ?>
			</td>
			<td>
				<?= $stats['pendingPrivate'] ?>
			</td>
			<td>
				<?= $stats['closedPrivate'] ?>
			</td>
			<td class="fw-bold">
				<?= $stats['totalPrivate'] ?>
			</td>
		</tr>
		<tr class="border-top">
			<th scope="row" class="fw-bold">
				<?= Text::_('COM_ATS_TICKETS_STATUS_TOTAL') ?>
			</th>
			<td class="fw-bold">
				<?= $stats['openTotal'] ?>
			</td>
			<td class="fw-bold">
				<?= $stats['pendingTotal'] ?>
			</td>
			<td class="fw-bold">
				<?= $stats['closedTotal'] ?>
			</td>
			<td class="fw-bold">
				<?= $stats['totalTotal'] ?>
			</td>
		</tr>
		</tbody>
	</table>
<?php endif; ?>