<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Module\Atstickets\Site\Helper;

use Akeeba\Component\ATS\Administrator\Model\TicketsModel;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;

defined('_JEXEC') or die;

class AtsTicketsHelper
{
	public function getMyStats(): array
	{
		$ret = [
			'allTickets'     => 0,
			'pendingTickets' => 0,
			'closedTickets'  => 0,
			'openTickets'    => 0,
			'isGuest'        => false,
		];

		$app = Factory::getApplication();
		$me  = $app->getIdentity();

		$ret['isGuest'] = empty($me) || $me->guest;

		if (!$this->hasAts() || $ret['isGuest'])
		{
			return $ret;
		}

		/** @var MVCFactoryInterface $mvcFactory */
		$mvcFactory = Factory::getApplication()->bootComponent('com_ats')->getMVCFactory();
		/** @var TicketsModel $model */
		$model = $mvcFactory->createModel('Tickets', 'Administrator', ['ignore_request' => true]);

		// Only count tickets created by the current user
		$model->setState('filter.created_by', (int) $me->id);

		// All tickets of the user
		$allTickets = $model->getTotal() ?: 0;

		// All open tickets by the user
		$model->setState('filter.status', 'O');
		$openTickets = $model->getTotal() ?: 0;

		// All closed tickets by the user
		$model->setState('filter.status', 'C');
		$closedTickets = $model->getTotal() ?: 0;

		// Pending (and custom status) tickets is the remained of the total tickets.
		$pendingTickets = $allTickets - $openTickets - $closedTickets;

		return [
			'allTickets'     => $allTickets,
			'pendingTickets' => $pendingTickets,
			'closedTickets'  => $closedTickets,
			'openTickets'    => $openTickets,
			'isGuest'        => false,
		];
	}

	/**
	 * Is the Akeeba Ticket System component installed and enabled?
	 *
	 * @return bool
	 *
	 * @since  5.0.0
	 */
	public function hasAts(): bool
	{
		return ComponentHelper::isInstalled('com_ats') && ComponentHelper::isEnabled('com_ats');
	}
}