<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\Input\Input;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;

/**
 * These variables are extracted from the indexed array returned by the
 * \Joomla\Module\Atstickets\Site\Dispatcher\Dispatcher::getLayoutData() method.
 *
 * @var stdClass                 $module         The module data loaded by Joomla
 * @var AdministratorApplication $app            The Joomla administrator application object
 * @var Input                    $input          The application input object
 * @var Registry                 $params         The module parameters
 * @var stdClass                 $template       The current admin template
 * @var bool                     $hasAts         Is ATS installed and enabled?
 * @var int                      $allTickets     Total number of tickets.
 * @var int                      $pendingTickets Total number of Pending (or custom status) tickets.
 * @var int                      $closedTickets  Total number of Closed tickets.
 * @var int                      $openTickets    Total number of Open tickets.
 * @var bool                     $isGuest        Is this user a guest?
 *
 * @see \Akeeba\Module\Atstickets\Site\Dispatcher\Dispatcher::getLayoutData()
 */

$preText       = trim($params->get('pretext', '') ?? '');
$preButtonText = trim($params->get('prebuttontext', '') ?? '');
$postText      = trim($params->get('posttext', '') ?? '');

?>
<div class="mod_atstickets">

	<?php if (!empty($preText)): ?>
		<div class="mod_atstickets-pretext mb-3">
			<?= $preText ?>
		</div>
	<?php endif; ?>

	<?php if ($params->get('show_open', 1)): ?>
		<div class="mod_atstickets-open mb-3 text-danger">
			<?= Text::plural('MOD_ATSTICKETS_LBL_OPENTICKETS_N', $openTickets); ?>
		</div>
	<?php endif; ?>

	<?php if ($params->get('show_pending', 1)): ?>
		<div class="mod_atstickets-open mb-3 text-warning">
			<?= Text::plural('MOD_ATSTICKETS_LBL_PENDINGTICKETS_N', $pendingTickets); ?>
		</div>
	<?php endif; ?>

	<?php if ($params->get('show_closed', 1)): ?>
		<div class="mod_atstickets-open mb-3 text-success">
			<?= Text::plural('MOD_ATSTICKETS_LBL_CLOSEDTICKETS_N', $closedTickets); ?>
		</div>
	<?php endif; ?>

	<?php if ($params->get('show_mytickets', 1) || $params->get('show_newticket', 1)): ?>
		<?php if (!empty($preButtonText)): ?>
			<div class="mod_atstickets-prebuttontext mb-3">
				<?= $preButtonText ?>
			</div>
		<?php endif; ?>

		<div class="mod_atstickets-buttons mb-3 row">
			<?php if ($params->get('show_mytickets', 1)): ?>
				<div class="mod_atstickets-mytickets col">
					<a href="<?= Route::_('index.php?option=com_ats&view=my') ?>" class="btn btn-primary"> <span
								class="fa fa-ticket-alt" aria-hidden="true"></span>
						<?= Text::_('MOD_ATSTICKETS_LBL_MYTICKETS'); ?>
					</a>
				</div>
			<?php endif; ?>
			<?php if ($params->get('show_newticket', 1)): ?>
				<div class="mod_atstickets-newticket col">
					<a href="<?= Route::_('index.php?option=com_ats&view=ticket&layout=newticket&id=0') ?>" class="btn btn-outline-success">
						<span class="fa fa-plus" aria-hidden="true"></span>
						<?= Text::_('MOD_ATSTICKETS_LBL_NEWTICKET'); ?>
					</a>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>

	<?php if (!empty($postText)): ?>
		<div class="mod_atstickets-posttext mb-3">
			<?= $postText ?>
		</div>
	<?php endif; ?>
</div>
