<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') || die;

use Akeeba\Component\ATS\Administrator\Extension\ATSComponent;
use Akeeba\Component\ATS\Administrator\Provider\CacheCleaner;
use Akeeba\Component\ATS\Administrator\Provider\ComponentParameters;
use Akeeba\Component\ATS\Administrator\Provider\RouterFactory;
use Joomla\CMS\Categories\CategoryFactoryInterface;
use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 */
	public function register(Container $container)
	{
		// Include the Composer autoloader
		require_once __DIR__ . '/../vendor/autoload.php';

		// Get Joomla services
		$container->registerServiceProvider(new CategoryFactory('Akeeba\\Component\\ATS'));
		$container->registerServiceProvider(new MVCFactory('Akeeba\\Component\\ATS'));
		$container->registerServiceProvider(new ComponentDispatcherFactory('Akeeba\\Component\\ATS'));
		$container->registerServiceProvider(new RouterFactory('\\Akeeba\\Component\\ATS'));
		$container->registerServiceProvider(new CacheCleaner());
		$container->registerServiceProvider(new ComponentParameters('com_ats'));

		$container->set(
			ComponentInterface::class,
			function (Container $container) {
				$component = new ATSComponent($container->get(ComponentDispatcherFactoryInterface::class));

				$component->setRegistry($container->get(Registry::class));
				$component->setMVCFactory($container->get(MVCFactoryInterface::class));
				$component->setCategoryFactory($container->get(CategoryFactoryInterface::class));
				$component->setRouterFactory($container->get(RouterFactoryInterface::class));

				return $component;
			}
		);
	}
};
