-- Clean up leftovers from the previous version (just in case)
DROP TABLE IF EXISTS "#__ats_attempts";
DROP TABLE IF EXISTS "#__ats_emailtemplates";
DROP TABLE IF EXISTS "#__ats_credittransactions";
DROP TABLE IF EXISTS "#__ats_creditconsumptions";
DROP TABLE IF EXISTS "#__ats_offlineschedules";
DROP TABLE IF EXISTS "#__ats_customfields";
DROP TABLE IF EXISTS "#__ats_customfields_cats";
DROP TABLE IF EXISTS "#__ats_buckets";
DROP TABLE IF EXISTS "#__ats_usertags";
DROP TABLE IF EXISTS "#__ats_users_usertags";

-- Create tables
CREATE TABLE IF NOT EXISTS "#__ats_tickets"
(
    "id"          SERIAL PRIMARY KEY,
    "catid"       BIGINT        NOT NULL,
    "status"      VARCHAR(2)    NOT NULL DEFAULT 'O',
    "title"       VARCHAR(1024) NOT NULL,
    "alias"       VARCHAR(255)  NOT NULL DEFAULT '',
    "public"      SMALLINT      NOT NULL DEFAULT 1,
    "priority"    SMALLINT      NOT NULL,
    "origin"      VARCHAR(10)   NOT NULL DEFAULT 'web',
    "assigned_to" BIGINT        NOT NULL DEFAULT 0,
    "timespent"   REAL          NOT NULL DEFAULT 0,
    "created"     TIMESTAMP              DEFAULT NULL,
    "created_by"  BIGINT        NOT NULL DEFAULT 0,
    "modified"    TIMESTAMP              DEFAULT NULL,
    "modified_by" BIGINT        NOT NULL DEFAULT 0,
    "enabled"     SMALLINT      NOT NULL DEFAULT 1,
    "params"      TEXT                   DEFAULT NULL
);

CREATE INDEX IF NOT EXISTS "#__ats_tickets_key" ON "#__ats_tickets" ("alias");

CREATE TABLE IF NOT EXISTS "#__ats_posts"
(
    "id"            SERIAL PRIMARY KEY,
    "attachment_id" VARCHAR(512) NOT NULL DEFAULT '0',
    "ticket_id"     BIGINT       NOT NULL,
    "content_html"  TEXT         NOT NULL,
    "origin"        VARCHAR(20)           DEFAULT 'web',
    "timespent"     REAL         NOT NULL DEFAULT 0,
    "email_uid"     VARCHAR(255)          DEFAULT NULL,
    "created"       TIMESTAMP             DEFAULT NULL,
    "created_by"    BIGINT       NOT NULL DEFAULT 0,
    "modified"      TIMESTAMP             DEFAULT NULL,
    "modified_by"   BIGINT       NOT NULL DEFAULT 0,
    "enabled"       SMALLINT     NOT NULL DEFAULT 1,
    CONSTRAINT "#__ats_posts_email_uid_key" UNIQUE ("email_uid")
);

CREATE INDEX IF NOT EXISTS "#__ats_posts_email_uid_key" ON "#__ats_posts" ("email_uid");

CREATE TABLE IF NOT EXISTS "#__ats_attachments"
(
    "id"                SERIAL PRIMARY KEY,
    "post_id"           INTEGER       NOT NULL,
    "original_filename" VARCHAR(1024) NOT NULL,
    "mangled_filename"  VARCHAR(1024) NOT NULL,
    "mime_type"         VARCHAR(255)  NOT NULL DEFAULT 'application/octet-stream',
    "origin"            VARCHAR(20)            DEFAULT 'web',
    "created"           TIMESTAMP              DEFAULT NULL,
    "created_by"        BIGINT        NOT NULL DEFAULT 0,
    "enabled"           SMALLINT      NOT NULL DEFAULT 1
);

CREATE INDEX IF NOT EXISTS "#__ats_attachment_post_id" ON "#__ats_attachments" ("post_id");

CREATE TABLE IF NOT EXISTS "#__ats_managernotes"
(
    "id"          SERIAL PRIMARY KEY,
    "ticket_id"   BIGINT   NOT NULL,
    "note_html"   TEXT     NOT NULL,
    "created"     TIMESTAMP         DEFAULT NULL,
    "created_by"  BIGINT   NOT NULL DEFAULT 0,
    "modified"    TIMESTAMP         DEFAULT NULL,
    "modified_by" BIGINT   NOT NULL DEFAULT 0,
    "enabled"     SMALLINT NOT NULL DEFAULT 1
);

CREATE TABLE IF NOT EXISTS "#__ats_cannedreplies"
(
    "id"               SERIAL PRIMARY KEY,
    "title"            VARCHAR(255) NOT NULL,
    "reply"            TEXT         NOT NULL,
    "ordering"         BIGINT       NOT NULL,
    "enabled"          SMALLINT     NOT NULL DEFAULT 1,
    "created"          TIMESTAMP             DEFAULT NULL,
    "created_by"       BIGINT                DEFAULT 0,
    "modified"         TIMESTAMP             DEFAULT NULL,
    "modified_by"      BIGINT                DEFAULT 0,
    "checked_out_time" TIMESTAMP             DEFAULT NULL,
    "checked_out"      BIGINT                DEFAULT 0,
    "access"           INTEGER               DEFAULT 0
);

CREATE TABLE IF NOT EXISTS "#__ats_autoreplies"
(
    id                SERIAL PRIMARY KEY,
    title             VARCHAR(50) NOT NULL,
    reply             TEXT        NOT NULL,
    ordering          SMALLINT    NOT NULL,
    enabled           SMALLINT    NOT NULL,
    run_after_manager SMALLINT    NOT NULL,
    num_posts         INTEGER     NOT NULL,
    min_after         INTEGER     NOT NULL,
    attachment        SMALLINT    NOT NULL,
    keywords_title    TEXT        NOT NULL,
    keywords_text     TEXT        NOT NULL,
    params            TEXT        NOT NULL
);

CREATE TABLE IF NOT EXISTS "#__ats_tickets_users"
(
    id        SERIAL PRIMARY KEY,
    ticket_id BIGINT NOT NULL,
    user_id   BIGINT NOT NULL
);

-- UCM Content types (for tagging)
DELETE
FROM "#__content_types"
WHERE "type_alias" = 'com_ats.ticket';

INSERT INTO "#__content_types"
("type_title", "type_alias", "table", "rules", "field_mappings", "router", "content_history_options")
VALUES ('Ticket', 'com_ats.ticket',
        '{"special": {"dbtable": "#__ats_tickets", "key": "id", "type": "TicketTable", "prefix": "Akeeba\\\\Component\\\\ATS\\\\Administrator\\\\Table\\\\", "config": "array()"}, "common": {"dbtable": "#__ucm_content", "key": "ucm_id", "type": "Corecontent", "prefix": "Joomla\\\\CMS\\\\Table\\\\", "config": "array()"}}',
        '',
        '{"common": {"core_content_item_id": "id", "core_title": "title", "core_state": "enabled", "core_alias": "alias", "core_created_time": "created", "core_modified_time": "modified", "core_params": "params", "core_catid": "catid"}, "special": {"public": "public", "priority": "priority", "origin": "origin", "assigned_to": "assigned_to"}}',
        'Akeeba\\Component\\ATS\\Site\\Helper\\Route::getTicketRoute', '');

--
-- Create the common table for all Akeeba extensions.
--
-- This table is never uninstalled when uninstalling the extensions themselves.
--
CREATE TABLE IF NOT EXISTS "#__akeeba_common"
(
    "key"   character varying(190) NOT NULL,
    "value" text                   NOT NULL,
    PRIMARY KEY ("key")
);