-- Drop tables if they exist
DROP TABLE IF EXISTS "#__ats_tickets";
DROP TABLE IF EXISTS "#__ats_posts";
DROP TABLE IF EXISTS "#__ats_attachments";
DROP TABLE IF EXISTS "#__ats_managernotes";
DROP TABLE IF EXISTS "#__ats_cannedreplies";
DROP TABLE IF EXISTS "#__ats_autoreplies";

-- Delete from other tables involving custom fields
DELETE FROM "#__fields_values"
WHERE "field_id" IN (
    SELECT "field_id"
    FROM "#__fields"
    WHERE "context" = 'com_ats.ticket'
);

-- Remove fields associated with ticket categories
DELETE FROM "#__fields_categories"
WHERE "category_id" IN (
    SELECT "id"
    FROM "#__categories" AS c
    WHERE c."extension" = 'com_ats'
);

DELETE FROM "#__fields"
WHERE "context" = 'com_ats.ticket';

-- Delete custom field groups
DELETE FROM "#__fields_groups"
WHERE "context" = 'com_ats.ticket';

-- Remove UCM content type for tickets
DELETE FROM "#__content_types"
WHERE "type_alias" = 'com_ats.ticket';

-- Remove UCM content entries used by tags
DELETE FROM "#__ucm_content"
WHERE "core_type_alias" = 'com_ats.ticket';

-- Remove ticket categories
DELETE FROM "#__categories"
WHERE "extension" = 'com_ats';

-- Remove mail templates
DELETE FROM "#__mail_templates"
WHERE "extension" = 'com_ats';