<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Controller;

use Akeeba\Component\ATS\Administrator\Mixin\ControllerEventsTrait;
use Akeeba\Component\ATS\Administrator\Mixin\ControllerReturnURLTrait;
use Akeeba\Component\ATS\Administrator\Mixin\ControllerReusableModelsTrait;
use Joomla\CMS\MVC\Controller\AdminController;

defined('_JEXEC') or die;

class PostsController extends AdminController
{
	use ControllerEventsTrait;
	use ControllerReusableModelsTrait;
	use ControllerReturnURLTrait;

	/** @inheritdoc */
	protected $text_prefix = 'COM_ATS_POSTS';

	/** @inheritdoc */
	public function getModel($name = 'Post', $prefix = 'Administrator', $config = ['ignore_request' => true])
	{
		return parent::getModel($name, $prefix, $config);
	}

	protected function onAfterDelete()
	{
		$this->applyReturnUrl();
	}

	protected function onAfterPublish()
	{
		$this->applyReturnUrl();
	}

	protected function onAfterUnpublish()
	{
		$this->applyReturnUrl();
	}

	public function checkToken($method = 'request', $redirect = true)
	{
		return parent::checkToken($method, $redirect);
	}
}