<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Extension;

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Service\CacheCleaner;
use Akeeba\Component\ATS\Administrator\Service\ComponentParameters;
use Akeeba\Component\ATS\Administrator\Service\Html\ATS;
use Joomla\CMS\Categories\CategoryServiceInterface;
use Joomla\CMS\Categories\CategoryServiceTrait;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Factory;
use Joomla\CMS\Fields\FieldsServiceInterface;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Tag\TagServiceInterface;
use Joomla\CMS\Tag\TagServiceTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Psr\Container\ContainerInterface;

class ATSComponent extends MVCComponent implements
	BootableExtensionInterface, CategoryServiceInterface, TagServiceInterface, FieldsServiceInterface, RouterServiceInterface
{
	use HTMLRegistryAwareTrait;
	use RouterServiceTrait;
	use CategoryServiceTrait
	{
		CategoryServiceTrait::getTableNameForSection insteadof TagServiceTrait;
		CategoryServiceTrait::getStateColumnForSection insteadof TagServiceTrait;
	}
	use TagServiceTrait;

	/**
	 * The container we were created with
	 *
	 * @since 5.2.0
	 * @var   Container
	 */
	private $container;

	/** @inheritdoc */
	public function boot(ContainerInterface $container)
	{
		$this->container = $container;
		$db              = $container->get(DatabaseInterface::class);
		$this->getRegistry()->register('ats', new ATS($db));
	}

	/**
	 * Get the Cache Cleaner service
	 *
	 * @return  CacheCleaner
	 *
	 * @since   5.2.0
	 */
	public function getCacheCleanerService(): CacheCleaner
	{
		return $this->container->get(CacheCleaner::class);
	}

	/**
	 * Get the Component Parameters service
	 *
	 * @return  ComponentParameters
	 *
	 * @since   5.2.0
	 */
	public function getComponentParametersService(): ComponentParameters
	{
		return $this->container->get(ComponentParameters::class);
	}

	/**
	 * Returns the Container the extension was created with.
	 *
	 * We are going to use it wherever we are not instantiated through the extension object, e.g. fields.
	 *
	 * @return  Container
	 * @since   5.2.0
	 */
	public function getContainer(): Container
	{
		return $this->container;
	}

	/** @inheritdoc */
	public function getContexts(): array
	{
		Factory::getApplication()->getLanguage()->load('com_ats', JPATH_ADMINISTRATOR);

		return [
			'com_ats.ticket'     => Text::_('COM_ATS_TITLE_TICKETS'),
			'com_ats.categories' => Text::_('JCATEGORY'),
		];
	}

	/** @inheritdoc */
	public function validateSection($section, $item = null)
	{
		if (!in_array($section, ['categories', 'ticket']))
		{
			return null;
		}

		return $section;
	}

	/** @inheritdoc */
	protected function getStateColumnForSection(?string $section = null)
	{
		return (strtolower($section) === 'category') ? 'published' : 'enabled';
	}

	/** @inheritdoc */
	protected function getTableNameForSection(?string $section = null)
	{
		return (strtolower($section) === 'category') ? 'categories' : 'ats_tickets';
	}
}