<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Helper;

use Joomla\CMS\Uri\Uri;

defined('_JEXEC') || die;

abstract class URLTransformation
{
	public static function convertURLsToAbsolute(?string $text): string
	{
		if (empty($text))
		{
			return '';
		}

		return preg_replace_callback(
			'#(src|srcset|href)\s*=\s*"([^"]*)"#',
			[self::class, 'makeURLAbsolute'],
			$text
		);
	}

	private static function makeURLAbsolute(array $matches): string
	{
		$attribute = $matches[1];
		$url       = $matches[2];

		if (strpos($url, 'https://') === 0 || strpos($url, 'http://') === 0)
		{
			return sprintf('%s="%s"', $attribute, $url);
		}

		if (strpos($url, '/') === 0)
		{
			$basePath = rtrim(Uri::root(true), '/');

			if (empty($basePath))
			{
				$url = rtrim(Uri::root(), '/') . '/' . ltrim($url, '/');

				return sprintf('%s="%s"', $attribute, $url);
			}

			if (strpos($url, $basePath) === 0)
			{
				$url = substr($url, strlen($basePath));
			}

			$url = rtrim(Uri::root(), '/') . '/' . ltrim($url, '/');

			return sprintf('%s="%s"', $attribute, $url);
		}

		$url = rtrim(Uri::root(), '/') . '/' . $url;

		return sprintf('%s="%s"', $attribute, $url);
	}
}