<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Mixin;

use Akeeba\Component\ATS\Administrator\Extension\ATSComponent;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

trait ComponentObjectTrait
{
	private ?ATSComponent $atsComponentObject;

	protected function getExtensionObject(): ATSComponent
	{
		$componentName = 'com_ats';

		if (!isset($this->atsComponentObject))
		{
			$app = function() {
				if (method_exists($this, 'getApplication'))
				{
					return $this->getApplication();
				}

				if (isset($this->app) && $this->app instanceof CMSApplication)
				{
					return $this->app;
				}

				if (isset($this->application) && $this->application instanceof CMSApplication)
				{
					return $this->application;
				}

				return Factory::getApplication();
			};

			$this->atsComponentObject =
				(method_exists($this, 'bootComponent') ? $this : $app())
					->bootComponent($componentName);
		}

		return $this->atsComponentObject;
	}
}