<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Mixin;

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Table\AbstractTable;
use Exception;
use Joomla\CMS\Language\Text;

/**
 * A trait to replace getItem with something which returns a real table instead of a plain old, stupid object
 */
trait ModelGetItemTrait
{
	/**
	 * Method to get a single record.
	 *
	 * @param   int|null  $pk  The id of the primary key.
	 *
	 * @return  AbstractTable|bool  Object on success, false on failure.
	 * @throws  Exception
	 * @since   5.0.0
	 */
	public function getItemTable($pk = null)
	{
		$pk    = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
		$table = $this->getTable();

		if ($pk > 0)
		{
			try
			{
				$isLoaded = $table->load($pk);

				if ($isLoaded === false)
				{
					/** @noinspection PhpDeprecationInspection */
					$error = method_exists($table, 'getError')
						? $table->getError()
						: Text::_('JLIB_APPLICATION_ERROR_NOT_EXIST');
				}
			}
			catch (Exception $e)
			{
				$isLoaded = false;
				$error    = $e->getMessage();
			}

			if ($isLoaded === false)
			{
				if (method_exists($table, 'setError'))
				{
					/** @noinspection PhpDeprecationInspection */
					$this->setError($error);

					return false;
				}

				throw new \RuntimeException($error);
			}
		}

		return $table;
	}

}