<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Model;

use Akeeba\UsageStats\Collector\Constants\SoftwareType;
use Akeeba\UsageStats\Collector\StatsCollector;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

defined('_JEXEC') or die;

#[\AllowDynamicProperties]
class UsagestatisticsModel extends BaseDatabaseModel
{
	/**
	 * Send site information to the remove collection service
	 *
	 * @return  bool
	 */
	public function collectStatistics()
	{
		$params = ComponentHelper::getParams('com_ats');

		// Is data collection turned off?
		if (!$params->get('stats_enabled', 1))
		{
			return false;
		}

		// Make sure the autoloader for our Composer dependencies is loaded.
		if (!class_exists(StatsCollector::class))
		{
			try
			{
				require_once JPATH_ADMINISTRATOR . '/components/com_ats/vendor/autoload.php';
			}
			catch (\Throwable $e)
			{
				return false;
			}
		}

		// Usage stats collection class is undefined, we cannot continue
		if (!class_exists(StatsCollector::class, false))
		{
			return false;
		}

		if (!defined('ATS_VERSION'))
		{
			@include_once __DIR__ . '/../../version.php';
		}

		if (!defined('ATS_VERSION'))
		{
			define('ATS_VERSION', 'dev');
			define('ATS_DATE', date('Y-m-d'));
		}

		try
		{
			(new StatsCollector(
				SoftwareType::ATS_JOOMLA_CORE,
				ATS_VERSION,
				defined('ATS_PRO') ? ATS_PRO : false
			))->conditionalSendStatistics();
		}
		catch (\Throwable $e)
		{
			return false;
		}

		return true;
	}
}