<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\Table;

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Helper\Filter;
use Akeeba\Component\ATS\Administrator\Mixin\TableAssertionTrait;
use Akeeba\Component\ATS\Administrator\Mixin\TableCreateModifyTrait;
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;

/**
 * Class CannedreplyTable
 *
 * @property int    $id               Post ID
 * @property string $title            Title of the canned reply
 * @property string $reply            Content of the canned reply
 * @property int    $ordering         Display order
 * @property int    $enabled          Published status
 * @property string $created          Created date/time, UTC
 * @property int    $created_by       User ID who created this canned reply
 * @property string $modified         Last modified date/time, UTC
 * @property int    $modified_by      User ID who last modified this canned reply
 * @property string $checked_out_time Last checked out date/time, UTC
 * @property int    $checked_out      User ID who checked out this canned reply
 * @property int    $access           Access Level ID
 *
 * @since   5.0.0
 */
class CannedreplyTable extends AbstractTable
{
	use TableCreateModifyTrait;
	use TableAssertionTrait;

	/**
	 * Public constructor
	 *
	 * @param   DatabaseDriver            $db          Database driver object to Joomla's DB
	 * @param   DispatcherInterface|null  $dispatcher  Joomla event dispatcher
	 *
	 * @return  void
	 * @since   5.0.0
	 */
	public function __construct(DatabaseDriver $db, ?DispatcherInterface $dispatcher  = null)
	{
		$this->_supportNullValue = true;

		parent::__construct('#__ats_cannedreplies', 'id', $db, $dispatcher);

		$this->setColumnAlias('published', 'enabled');
	}


	/**
	 * Checks and sanitizes data before saving them.
	 *
	 * @return  void
	 *
	 * @since   5.0.0
	 */
	protected function onBeforeCheck(): void
	{
		$this->title = trim($this->title ?? '');
		$this->reply = Filter::filterText($this->reply ?? '');

		$this->assertNotEmpty($this->title, 'COM_ATS_CANNEDREPLY_ERR_TITLE_EMPTY');
		$this->assertNotEmpty($this->reply, 'COM_ATS_CANNEDREPLY_ERR_REPLY_EMPTY');
	}
}