<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\View\Controlpanel;

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Mixin\ViewLoadAnyTemplateTrait;
use Akeeba\Component\ATS\Administrator\Mixin\ViewTaskBasedEventsTrait;
use Akeeba\Component\ATS\Administrator\Model\ControlpanelModel;
use Akeeba\Component\ATS\Administrator\Model\UpdatesModel;
use Akeeba\Component\ATS\Administrator\Model\UsagestatisticsModel;
use DateInterval;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Throwable;

class HtmlView extends BaseHtmlView
{
	use ViewTaskBasedEventsTrait;
	use ViewLoadAnyTemplateTrait;

	/**
	 * Do I have to ask the user to provide a Download ID?
	 *
	 * @var   bool
	 * @since 5.0.0
	 */
	public $needsdlid = false;

	/**
	 * The fancy formatted changelog of the component
	 *
	 * @var   string
	 * @since 5.0.0
	 */
	public $formattedChangelog = '';

	/**
	 * Update site ID
	 *
	 * @var   int
	 * @since 5.0.0
	 */
	public $updateSiteId = 0;

	public function onBeforeMain()
	{
		// Is this the Professional release?
		$this->isPro = (ATS_PRO ?? 0) == 1;

		// Load the models
		/** @var ControlpanelModel $controlPanelModel */
		$controlPanelModel = $this->getModel();

		/** @var UpdatesModel $updatesModel */
		$updatesModel = $this->getModel('Updates');

		$this->formattedChangelog    = $this->formatChangelog();
		$this->needsdlid             = $controlPanelModel->needsDownloadID();
		$this->updateSiteId          = $updatesModel->getUpdateSiteIds()[0];

		try
		{
			$this
				->getModel('Usagestatistics')
				->collectStatistics();
		}
		catch (Throwable $e)
		{
		}

		$webAssetManager = $this->getDocument()->getWebAssetManager();
		$webAssetManager
			->useScript('com_ats.controlpanel');

		$earliestDate   = (clone Factory::getDate())->sub(new DateInterval('P1M'))->setTime(0, 0, 0, 0);

		$this->getDocument()->addScriptOptions('atsGraphs', [
			'ajaxUrl' => Route::_('index.php?option=com_ats&task=controlpanel.getTicketStats&format=json', false, Route::TLS_IGNORE, true),
			'since' => $earliestDate->toISO8601(),
		]);

		ToolbarHelper::title(sprintf(Text::_('COM_ATS')), 'icon-ats');
		ToolbarHelper::preferences('com_ats');
	}

	protected function formatChangelog($onlyLast = false)
	{
		$ret   = '';
		$file  = JPATH_ADMINISTRATOR . '/components/com_ats/CHANGELOG.php';
		$lines = @file($file);

		if (empty($lines))
		{
			return $ret;
		}

		array_shift($lines);

		foreach ($lines as $line)
		{
			$line = trim($line);

			if (empty($line))
			{
				continue;
			}

			$type = substr($line, 0, 1);

			switch ($type)
			{
				case '=':
					continue 2;
					break;

				case '+':
					$ret .= "\t" . '<li><span class="badge bg-success">Added</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				case '-':
					$ret .= "\t" . '<li><span class="badge bg-dark">Removed</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				case '~':
				case '^':
					$ret .= "\t" . '<li><span class="badge bg-secondary">Changed</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				case '*':
					$ret .= "\t" . '<li><span class="badge bg-danger">Security</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				case '!':
					$ret .= "\t" . '<li><span class="badge bg-warning text-dark">Important</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				case '#':
					$ret .= "\t" . '<li><span class="badge bg-info text-dark">Fixed</span> ' . htmlentities(trim(substr($line, 2))) . "</li>\n";
					break;

				default:
					if (!empty($ret))
					{
						$ret .= "</ul>";
						if ($onlyLast)
						{
							return $ret;
						}
					}

					if (!$onlyLast)
					{
						$ret .= "<h4>$line</h4>\n";
					}
					$ret .= "<ul class=\"akeeba-changelog\">\n";

					break;
			}
		}

		return $ret;
	}

}
