<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Administrator\View\Post;

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Akeeba\Component\ATS\Administrator\Mixin\ViewLoadAnyTemplateTrait;
use Akeeba\Component\ATS\Administrator\Model\PostModel;
use Akeeba\Component\ATS\Administrator\Table\PostTable;
use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseHtmlView
{
	use ViewLoadAnyTemplateTrait;

	/**
	 * The URL to return to after editing
	 *
	 * @var   string|null
	 * @since 5.0.0
	 */
	public $returnUrl;

	/**
	 * Privileges of the currently logged in user for this ticket
	 *
	 * @var   array{view:bool,post:bool,delete:bool,edit:bool,"edit.state":bool,admin:bool,close:bool,attachment:bool}
	 * @since 5.0.0
	 */
	protected $canDo;

	/**
	 * The Form object
	 *
	 * @var    Form
	 * @since  5.0.0
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var    PostTable
	 * @since  5.0.0
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var    object
	 * @since  5.0.0
	 */
	protected $state;

	/** @inheritdoc */
	public function display($tpl = null)
	{
		/** @var PostModel $model */
		$model       = $this->getModel();
		$this->item  = $model->getItem();
		$this->form  = $model->getForm($this->item->getProperties());
		$this->state = $model->getState();

		// Check for errors.
		if (method_exists($this->getModel(), 'getErrors'))
		{
			/** @noinspection PhpDeprecationInspection */
			$errors = $this->getModel()->getErrors();

			if (is_countable($errors) && count($errors))
			{
				throw new GenericDataException(implode("\n", $errors), 500);
			}
		}

		$ticket      = $this->item->getTicket();
		$this->canDo = Permissions::getPostPrivileges($this->item);

		// Set the category for Canned Replies permissions checks
		Factory::getApplication()->getSession()->set('com_ats.cannedreplies.category', $ticket->catid);

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Set up Joomla's toolbar.
	 *
	 * @return  void
	 * @throws  Exception
	 * @since   5.0.0
	 */
	protected function addToolbar(): void
	{
		Factory::getApplication()->getInput()->set('hidemainmenu', true);

		$isNew = empty($this->item->id);

		ToolbarHelper::title(Text::_('COM_ATS_TITLE_POSTS_' . ($isNew ? 'ADD' : 'EDIT')), 'icon-ats');

		ToolbarHelper::save('post.save');
		ToolbarHelper::apply('post.apply');

		ToolbarHelper::cancel('post.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
	}
}
