<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;

$buttonLayout = new FileLayout('akeeba.ats.cpanel.button');
?>

<h3 class="ps-3 border-bottom">
	<?= Text::_('COM_ATS_CONTROLPANEL_HEAD_MAINOPS') ?>
</h3>
<div class="akeeba-cpanel-container mb-3 d-flex flex-row flex-wrap align-items-stretch gap-2">
	<?= $buttonLayout->render([
		'color' => 'primary',
		'link' => 'index.php?option=com_ats&view=tickets',
		'icon' => 'fa fa-fw fa-ticket-alt',
		'label' => 'COM_ATS_TITLE_TICKETS'
	]) ?>

	<?php if (defined('ATS_PRO') && ATS_PRO): ?>

	<?php if (!ComponentHelper::getParams('com_ats')->get('timespent_hide', 1)): ?>
	<?= $buttonLayout->render([
		'color' => 'success',
		'link' => 'index.php?option=com_ats&view=Timecard',
		'icon' => 'fa fa-fw fa-clock',
		'label' => 'COM_ATS_TITLE_TIMECARD'
	]) ?>
	<?php endif ?>

	<?= $buttonLayout->render([
		'color' => 'info',
		'link' => 'index.php?option=com_ats&view=Log',
		'icon' => 'fa fa-fw fa-clipboard-list',
		'label' => 'COM_ATS_TITLE_LOG'
	]) ?>
	<?php endif ?>
</div>

<h3 class="ps-3 border-bottom">
	<?= Text::_('COM_ATS_CONTROLPANEL_HEAD_CONFIG') ?>
</h3>

<div class="akeeba-cpanel-container mb d-flex flex-row flex-wrap align-items-stretch gap-2">
	<?= $buttonLayout->render([
		'color' => 'dark',
		'link' => 'index.php?option=com_categories&extension=com_ats',
		'icon' => 'icon-folder',
		'label' => 'COM_ATS_SUBMENU_CATEGORIES'
	]) ?>

	<?= $buttonLayout->render([
		'color' => 'secondary',
		'link' => 'index.php?option=com_fields&view=groups&context=com_ats.ticket',
		'icon' => 'icon-puzzle-piece',
		'label' => 'JGLOBAL_FIELD_GROUPS'
	]) ?>

	<?= $buttonLayout->render([
		'color' => 'secondary',
		'link' => 'index.php?option=com_fields&view=fields&context=com_ats.ticket',
		'icon' => 'icon-puzzle-piece',
		'label' => 'JGLOBAL_FIELDS'
	]) ?>

	<?php if (defined('ATS_PRO') && ATS_PRO): ?>
	<?= $buttonLayout->render([
		'color' => 'info',
		'link' => 'index.php?option=com_ats&view=Emailtemplates',
		'icon' => 'fa fa-fw fa-envelope',
		'label' => 'COM_ATS_TITLE_EMAILTEMPLATES'
	]) ?>

	<?= $buttonLayout->render([
		'color' => 'warning',
		'link' => 'index.php?option=com_ats&view=Autoreplies',
		'icon' => 'fa fa-fw fa-robot',
		'label' => 'COM_ATS_TITLE_AUTOREPLIES'
	]) ?>

	<?= $buttonLayout->render([
		'color' => 'danger',
		'link' => 'index.php?option=com_ats&view=Cannedreplies',
		'icon' => 'fa fa-fw fa-scroll',
		'label' => 'COM_ATS_TITLE_CANNEDREPLIES'
	]) ?>

	<?= $buttonLayout->render([
		'color' => 'secondary',
		'link' => 'index.php?option=com_ats&view=Scheduling',
		'icon' => 'fa fa-fw fa-calendar-alt',
		'label' => 'COM_ATS_TITLE_SCHEDULINGINFO'
	]) ?>
	<?php endif ?>

</div>