<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Administrator\View\Controlpanel\HtmlView $this */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

HTMLHelper::_('bootstrap.modal' ,'#akeeba-changelog');

?>
<div class="card mb-3">
	<h3 class="card-header bg-info text-white h4">
		<?= Text::_('COM_ATS_CONTROLPANEL_LBL_VERSIONINFO') ?>
	</h3>
	<div class="card-body">
		<div class="d-flex align-items-center">
			<div class="fw-bold me-2">
				Akeeba Ticket System
				<?php if (ATS_PRO): ?>
					<span class="text-info">Professional</span>
				<?php else: ?>
					<span class="text-muted">Core</span>
				<?php endif; ?>
				<?= ATS_VERSION ?>
			</div>

			<button type="button"
			        id="btnchangelog" class="btn btn-sm btn-outline-info"
			        data-bs-toggle="modal" data-bs-target="#akeeba-changelog">
				<span class="fa fa-clipboard-check"></span>
				<?= Text::_('COM_ATS_CONTROLPANEL_LBL_CHANGELOG') ?>
			</button>
		</div>

		<div class="text-muted mb-1">
			<?= Text::sprintf('COM_ATS_CONTROLPANEL_LBL_INFO_COPYRIGHT', (clone Factory::getDate(ATS_DATE ?? gmdate('Y-m-d')))->format('Y')) ?>
		</div>

		<div class="text-muted small mb-2">
			<?= Text::_('COM_ATS_CONTROLPANEL_LBL_INFO_GPL_NOTICE') ?>
		</div>

		<?php if (!($this->isPro)): ?>
			<div class="text-center mb-4">
				<a href="https://www.paypal.com/donate?hosted_button_id=6ZLKK32UVEPWA"
				   class="btn btn-outline-primary">
					<span class="fa fab fa-paypal"></span>
					<?= Text::_('COM_ATS_CONTROLPANEL_LBL_DONATE') ?>
				</a>
			</div>
		<?php endif; ?>

	</div>
</div>

<div class="modal fade" id="akeeba-changelog" tabindex="-1"
     aria-labelledby="akeeba-changelog-header" aria-hidden="true"
     role="dialog">
	<div class="modal-dialog modal-dialog-scrollable modal-dialog-centered modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h3 id="akeeba-changelog-header">
					<?= Text::_('COM_ATS_CONTROLPANEL_LBL_CHANGELOG') ?>
				</h3>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?= Text::_('JLIB_HTML_BEHAVIOR_CLOSE') ?>"></button>
			</div>
			<div class="modal-body p-3">
				<?= $this->formattedChangelog ?>
			</div>
		</div>
	</div>
</div>