<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Administrator\View\Controlpanel\HtmlView $this */

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

// DO NOT REMOVE array_values. It is used to reindex the array so that whereIn in the model works at all!
$pendingStatuses = array_values(array_diff(array_keys(Permissions::getStatuses()), ['O', 'C']));

/** @var \Akeeba\Component\ATS\Administrator\Model\ControlpanelModel $model */
$model = $this->getModel();
$openPublic = $model->countTickets(true, ['O']);
$pendingPublic = $model->countTickets(true, $pendingStatuses);
$closedPublic = $model->countTickets(true, ['C']);
$totalPublic = $openPublic + $pendingPublic + $closedPublic;

$openPrivate = $model->countTickets(false, ['O']);
$pendingPrivate = $model->countTickets(false, $pendingStatuses);
$closedPrivate = $model->countTickets(false, ['C']);
$totalPrivate = $openPrivate + $pendingPrivate + $closedPrivate;

$openTotal = $openPublic + $openPrivate;
$pendingTotal = $pendingPublic + $pendingPrivate;
$closedTotal = $closedPublic + $closedPrivate;

$totalTotal = $totalPublic + $totalPrivate;

?>
<table class="table table-hover table-responsive">
	<caption>
		<?= Text::_('COM_ATS_CPANEL_STATS') ?>
	</caption>
	<thead>
	<tr>
		<td>&nbsp;</td>
		<th scope="col">
			<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=O') ?>">
				<?= Text::_('COM_ATS_TICKETS_STATUS_O') ?>
			</a>
		</th>
		<th scope="col">
			<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=P') ?>">
				<?= Text::_('COM_ATS_TICKETS_STATUS_P') ?>
			</a>
		</th>
		<th scope="col">
			<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=C') ?>">
				<?= Text::_('COM_ATS_TICKETS_STATUS_C') ?>
			</a>
		</th>
		<th scope="col">
			<a href="<?= Route::_('index.php?option=com_ats&view=tickets&filter[status]=') ?>">
				<?= Text::_('COM_ATS_TICKETS_STATUS_TOTAL') ?>
			</a>
		</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<th scope="row">
			<?= Text::_('COM_ATS_TICKETS_PUBLIC_PUBLIC') ?>
		</th>
		<td>
			<?= $openPublic ?>
		</td>
		<td>
			<?= $pendingPublic ?>
		</td>
		<td>
			<?= $closedPublic ?>
		</td>
		<td class="fw-bold">
			<?= $totalPublic ?>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<?= Text::_('COM_ATS_TICKETS_PUBLIC_PRIVATE') ?>
		</th>
		<td>
			<?= $openPrivate ?>
		</td>
		<td>
			<?= $pendingPrivate ?>
		</td>
		<td>
			<?= $closedPrivate ?>
		</td>
		<td class="fw-bold">
			<?= $totalPrivate ?>
		</td>
	</tr>
	<tr class="border-top">
		<th scope="row" class="fw-bold">
			<?= Text::_('COM_ATS_TICKETS_STATUS_TOTAL') ?>
		</th>
		<td class="fw-bold">
			<?= $openTotal ?>
		</td>
		<td class="fw-bold">
			<?= $pendingTotal ?>
		</td>
		<td class="fw-bold">
			<?= $closedTotal ?>
		</td>
		<td class="fw-bold">
			<?= $totalTotal ?>
		</td>
	</tr>
	</tbody>
</table>

