<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Administrator\View\Post\HtmlView $this */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

if (version_compare(JVERSION, '5.999.999', 'lt'))
{
	HTMLHelper::_('behavior.formvalidator');
	HTMLHelper::_('behavior.keepalive');
}
else
{
	$wa = \Joomla\CMS\Factory::getApplication()->getDocument()->getWebAssetManager();
	$wa
			->useScript('form.validate')
			->useScript('keepalive');
}

?>
<form action="<?= Route::_('index.php?option=com_ats&view=post&layout=edit&id=' . $this->item->id) ?>"
      method="post"
      name="adminForm"
      id="adminForm"
      class="form-validate"
      aria-label="<?= Text::_('COM_ATS_TITLE_POSTS_EDIT', true) ?>"
>
	<input type="hidden" name="task" value="">
	<?php if (!empty($this->returnUrl)): ?>
	<input type="hidden" name="returnurl" value="<?= base64_encode($this->returnUrl) ?>">
	<?php endif; ?>
	<?= HTMLHelper::_('form.token') ?>

	<?php foreach (array_keys($this->form->getFieldsets()) as $fieldSet): ?>
	<div class="card mb-2 h-100">
		<?php if ($this->form->getFieldsets()[$fieldSet]->label): ?>
		<h3 class="card-header bg-info text-white">
			<?= Text::_($this->form->getFieldsets()[$fieldSet]->label) ?>
		</h3>
		<?php endif; ?>
		<div class="card-body">
			<?php echo $this->form->renderFieldset($fieldSet); ?>
		</div>
	</div>
	<?php endforeach; ?>
</form>
