<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Administrator\View\Ticket\HtmlView $this */

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Akeeba\Component\ATS\Administrator\Table\TicketTable;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\DatabaseInterface;

if (version_compare(JVERSION, '5.999.999', 'lt'))
{
	HTMLHelper::_('behavior.formvalidator');
	HTMLHelper::_('behavior.keepalive');
}
else
{
	$wa = \Joomla\CMS\Factory::getApplication()->getDocument()->getWebAssetManager();
	$wa
			->useScript('form.validate')
			->useScript('keepalive');
}

$ticket = new TicketTable(Factory::getContainer()->get(DatabaseInterface::class));

$knownFieldSets  = ['basic', 'details'];
$customFieldSets = array_diff(array_keys($this->form->getFieldsets()), $knownFieldSets);
$posts           = $ticket->posts($this->item->id);
$managerNotes    = $ticket->managerNotes($this->item->id);
$canViewNotes    = $this->canDo['admin'] || $this->canDo['notes.read'];
$canMakeNotes    = $this->canDo['admin'] || $this->canDo['notes.create'];
$my              = Factory::getApplication()->getIdentity();
$token           = Factory::getApplication()->getFormToken();

?>
<?= HTMLHelper::_('uitab.startTabSet', 'com_ats_admin_ticket', [
		'recall' => true,
]) ?>

<?= HTMLHelper::_('uitab.addTab', 'com_ats_admin_ticket', 'info', Text::_('COM_ATS_TICKETS_TAB_INFO')) ?>
<form action="<?= Route::_('index.php?option=com_ats&view=ticket&layout=edit&id=' . $this->item->id) ?>"
	  method="post"
	  name="adminForm"
	  id="adminForm"
	  class="form-validate"
	  aria-label="<?= Text::_('COM_ATS_TITLE_TICKETS_EDIT', true) ?>"
>
	<input type="hidden" name="task" value="">
	<?= HTMLHelper::_('form.token') ?>

	<div class="row row-cols-1 row-cols-md-2 g-1">
		<?php foreach ($knownFieldSets as $fieldSet):
			$fieldsInSet = $this->form->getFieldset($fieldSet);
			if (empty($fieldsInSet)) continue;
			?>
			<div class="col">
				<div class="card mb-2 h-100">
					<h3 class="card-header bg-info text-white">
						<?= Text::_($this->form->getFieldsets()[$fieldSet]->label) ?>
					</h3>
					<div class="card-body">
						<?php echo $this->form->renderFieldset($fieldSet); ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>

		<?php foreach($customFieldSets as $fieldSet):
			$fieldsInSet = $this->form->getFieldset($fieldSet);
			if (empty($fieldsInSet)) continue;
			?>
			<div class="col">
				<div class="card mb-2 h-100">
					<h3 class="card-header bg-dark text-white">
						<?= Text::_($this->form->getFieldsets()[$fieldSet]->label) ?>
					</h3>
					<div class="card-body">
						<?php echo $this->form->renderFieldset($fieldSet); ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</form>

<?= HTMLHelper::_('uitab.endTab') ?>



<?= HTMLHelper::_('uitab.addTab', 'com_ats_admin_ticket', 'posts', Text::_('COM_ATS_TICKETS_LEGEND_CONVO')) ?>
<section class="ats_ticket_backend_conversation">
	<?php if (empty($posts)): ?>
		<div class="alert alert-info">
			<span class="icon-info-circle" aria-hidden="true"></span>
			<span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
			<?= Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
		</div>
	<?php endif; ?>
	<?php foreach($posts as $post): ?>
		<?= $this->loadAnyTemplate('common_post', false, [
			'post' => $post,
		]) ?>
	<?php endforeach; ?>
</section>

<?php if ($this->canDo['post']): ?>
	<?= $this->loadAnyTemplate('common_reply', false) ?>
<?php elseif (!$this->canDo['admin'] && ($this->item->status === 'C')): ?>
	<div class="alert alert-danger">
		<h4 class="alert-heading">
			<?= Text::_('COM_ATS_POST_LBL_CLOSEDNOTICE_HEAD') ?>
		</h4>
		<p class="mb-0">
			<?= Text::_('COM_ATS_POST_LBL_CLOSEDNOTICE') ?>
		</p>
	</div>
<?php endif ?>
<?= HTMLHelper::_('uitab.endTab') ?>



<?php if($canViewNotes && defined('ATS_PRO') && ATS_PRO): ?>
<?= HTMLHelper::_('uitab.addTab', 'com_ats_admin_ticket', 'managernotes', Text::_('COM_ATS_TICKETS_LEGEND_MANAGERNOTES')) ?>
<section class="ats_ticket_backend_conversation">
	<?php if (empty($managerNotes)): ?>
	<div class="alert alert-info">
		<span class="icon-info-circle" aria-hidden="true"></span>
		<span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
		<?= Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
	</div>
	<?php endif; ?>
	<?php foreach($managerNotes as $managerNote): ?>
		<?= $this->loadAnyTemplate('common_managernote', false, [
			'managerNote' => $managerNote,
		]) ?>
	<?php endforeach; ?>
</section>
<?php if ($canMakeNotes): ?>
	<?= $this->loadAnyTemplate('common_newnote', false) ?>
<?php endif; ?>
<?= HTMLHelper::_('uitab.endTab') ?>
<?php endif ;?>

<?= HTMLHelper::_('uitab.addTab', 'com_ats_admin_ticket', 'invitedusers', Text::_('COM_ATS_TICKETS_LEGEND_INVITEDUSERS')) ?>
<section class="ats_ticket_backend_invited_users d-flex flex-column">
    <?php if ($this->canDo['ticket.invite'] && !$this->item->isNew()): ?>
        <form class="row row-cols-lg-auto align-items-center" style="display: inline-block"
              action="<?= Route::_('index.php?option=com_ats&task=ticket.invite') ?>"
              method="post"
        >
            <input type="hidden" name="id" value="<?= $this->item->id ?>">
            <input type="hidden" name="returnurl" value="<?= base64_encode(Uri::getInstance()->toString(['scheme', 'user', 'pass', 'host', 'port', 'path', 'query', 'fragment'])) ?>">
            <?= HTMLHelper::_('form.token') ?>

			<div class="input-group mb-3">
                <label class="visually-hidden" for="inlineFormInputGroupUsername"><?= Text::_('JGLOBAL_USERNAME') ?></label>
				<input type="text" class="form-control form-control-sm" name="invite_user" placeholder="<?= Text::_('JGLOBAL_USERNAME') ?>" aria-label="<?= Text::_('JGLOBAL_USERNAME') ?>">
				<button type="submit" class="btn btn-sm btn-primary">
					<span class="fa fa-user-plus" aria-hidden="true"></span>
				</button>
			</div>

	        <?php if (empty($this->invited_users)): ?>
				<div class="alert alert-info mx-5">
					<span class="icon-info-circle" aria-hidden="true"></span>
					<span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
			        <?= Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
				</div>
	        <?php endif; ?>

		</form>
    <?php endif; ?>

	<div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5">
    <?php foreach ($this->invited_users as $user):
        $remove_url  = 'index.php?option=com_ats&task=tickets.removeinvite&userid='.$user->id;
        $remove_url .= '&cid='.$this->item->id;
        $remove_url .= '&returnurl='.base64_encode(Uri::getInstance());
        $remove_url .= '&'.$token.'=1';

        $can_remove = false;

        // If I'm a manager, I can remove invited people
        if (Permissions::isManager($this->item->catid))
        {
            $can_remove = true;
        }
        // I can always remove myself
        elseif ($user->id == $my->id)
        {
            $can_remove = true;
        }
        ?>
		<div>
        <?php if ($can_remove): ?>
			<a id="ats-remove-invite" class="btn btn-sm btn-outline-danger me-2 hasTooltip"
			   href="<?php echo $remove_url ?>"
			   title="<?= Text::_('COM_ATS_TICKET_INVITE_REMOVE') ?>"
			>
				<span class="fa fa-trash" aria-hidden="true"></span>
				<span id="ats-remove-invite-label" class="visually-hidden"><?= Text::_('COM_ATS_TICKET_INVITE_REMOVE') ?></span>
			</a>
			<?php endif; ?>
			<span class="font-monospace"><?php echo $user->username ?></span>
		</div>
    <?php endforeach; ?>
	</div>

</section>

<?= HTMLHelper::_('uitab.endTab') ?>


<?= HTMLHelper::_('uitab.endTabSet') ?>
