<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Administrator\View\Ticket\HtmlView $this */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

if (version_compare(JVERSION, '5.999.999', 'lt'))
{
	HTMLHelper::_('behavior.formvalidator');
	HTMLHelper::_('behavior.keepalive');
}
else
{
	$wa = \Joomla\CMS\Factory::getApplication()->getDocument()->getWebAssetManager();
	$wa
			->useScript('form.validate')
			->useScript('keepalive');
}

$knownFieldsets = ['basic', 'post'];
$customFieldSets = array_diff(array_keys($this->form->getFieldsets()), $knownFieldsets);

?>
<form action="<?= Route::_('index.php?option=com_ats&view=ticket&layout=edit') ?>"
      method="post"
      name="adminForm" id="adminForm"
      class="form-validate"
	  enctype="multipart/form-data"
      aria-label="<?= Text::_('COM_ATS_TITLE_TICKETS_ADD', true) ?>"
>
	<input type="hidden" name="task" value="reload">
	<?= HTMLHelper::_('form.token') ?>

	<div class="card mb-2 h-100">
		<h3 class="card-header bg-info text-white">
			<?= Text::_($this->form->getFieldsets()['basic']->label) ?>
		</h3>
		<div class="card-body">
			<?php echo $this->form->renderFieldset('basic'); ?>
		</div>
	</div>

	<?php if (!empty($customFieldSets)): ?>
	<div class="row row-cols-1 row-cols-md-2 g-1 mb-2">
		<?php foreach ($customFieldSets as $fieldSet): ?>
			<div class="col">
				<div class="card mb-2 h-100">
					<h3 class="card-header bg-dark text-white">
						<?= Text::_($this->form->getFieldsets()[$fieldSet]->label) ?>
					</h3>
					<div class="card-body">
						<?php echo $this->form->renderFieldset($fieldSet); ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
	<?php endif; ?>

	<?php if ($this->form->getValue('catid')): ?>
	<div class="card mb-2 h-100">
		<h3 class="card-header bg-secondary text-white visually-hidden">
			<?= Text::_('COM_ATS_TITLE_POSTS_ADD') ?>
		</h3>
		<div class="card-body">
			<div class="card-body">
				<?php echo $this->form->renderFieldset('post'); ?>
			</div>
		</div>
	</div>
	<?php else: ?>
	<div class="alert alert-info">
		<h4 class="alert-heading">
			<?= Text::_('COM_ATS_TICKETS_LBL_NEWTICKET_NOCATEGORY_HEAD') ?>
		</h4>
		<p>
			<?= Text::_('COM_ATS_TICKETS_LBL_NEWTICKET_NOCATEGORY_BODY') ?>
		</p>
	</div>
	<?php endif; ?>
</form>
