<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Akeeba\Component\ATS\Administrator\Model\TicketsModel;
use Akeeba\Component\ATS\Site\Helper\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Database\DatabaseInterface;

/** @var \Akeeba\Component\ATS\Administrator\View\Tickets\HtmlView $this */

/**
 * HTMLHelper's `behavior.multiselect` is deprecated in Joomla 6.
 *
 * See Joomla PR 45925.
 */
call_user_func(function(string $formName = 'adminForm') {
	if (version_compare(JVERSION, '5.999.999', 'lt'))
	{
		HTMLHelper::_('behavior.multiselect');

		return;
	}

	$doc       = \Joomla\CMS\Factory::getApplication()->getDocument();
	$doc->addScriptOptions('js-multiselect', ['formName' => $formName]);
	$doc->getWebAssetManager()->useScript('multiselect');
});

$this->tableColumnsAutohide();
$this->tableColumnsMultiselect('#ticketsList');

/** @var TicketsModel $model */
$model     = $this->getModel();
$user      = Permissions::getUser();
$userId    = $user->id;
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$nullDate  = Factory::getContainer()->get(DatabaseInterface::class)->getNullDate();

?>
<form action="<?php echo Route::_('index.php?option=com_ats&view=tickets'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
			<?= LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
			<?php if (empty($this->items)) : ?>
				<div class="alert alert-info">
					<span class="icon-info-circle" aria-hidden="true"></span>
					<span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
					<?= Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
				</div>
			<?php else : ?>
				<table class="table" id="ticketsList">
					<caption class="visually-hidden">
						<?= Text::_('COM_ATS_TICKETS_TABLE_CAPTION'); ?>,
						<span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
						<span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
					</caption>
					<thead>
					<tr>
						<td class="w-1 text-center">
							<?= HTMLHelper::_('grid.checkall'); ?>
						</td>
						<th scope="col" class="w-20 d-none d-md-table-cell">
							<?= HTMLHelper::_('searchtools.sort', 'COM_ATS_TICKETS_HEADING_USER', 'created_name', $listDirn, $listOrder); ?>
						</th>
						<th scope="col" class="w-20 d-none d-md-table-cell">
							<?= HTMLHelper::_('searchtools.sort', 'COM_ATS_TICKETS_HEADING_CREATED', 'created', $listDirn, $listOrder); ?>
						</th>
						<th scope="col">
							<?= HTMLHelper::_('searchtools.sort', 'COM_ATS_TICKETS_HEADING_TITLE', 'title', $listDirn, $listOrder); ?>
						</th>
						<th scope="col">
							<?= HTMLHelper::_('searchtools.sort', 'JSTATUS', 'enabled', $listDirn, $listOrder); ?>
						</th>
						<th scope="col">
							<?= HTMLHelper::_('searchtools.sort', 'COM_ATS_TICKETS_HEADING_PUBLIC', 'public', $listDirn, $listOrder); ?>
						</th>
						<?php if ($this->showTimeSpent): ?>
						<th scope="col">
							<?= HTMLHelper::_('searchtools.sort', 'COM_ATS_TICKETS_HEADING_TIMESPENT', 'timespent', $listDirn, $listOrder); ?>
						</th>
						<?php endif ?>
						<?php if (Multilanguage::isEnabled()) : ?>
						<th scope="col" class="w-10 d-none d-md-table-cell">
							<?= HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language_title', $listDirn, $listOrder); ?>
						</th>
						<?php endif; ?>
						<th scope="col" class="w-5 d-none d-md-table-cell">
							<?= HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 't.id', $listDirn, $listOrder); ?>
						</th>
					</tr>
					</thead>
					<tbody data-nested="false">
					<?php
					$n = count($this->items);
					foreach ($this->items as $i => $item) :
						$canCreate       = $user->authorise('core.create', 'com_ats.category.' . $item->catid);
						$canEdit         = $user->authorise('core.edit', 'com_ats.category.' . $item->catid);
						$canEditOwn      = $user->authorise('core.edit.own', 'com_ats.category.' . $item->catid) && $item->created_by == $userId;
						$canChange       = $user->authorise('core.edit.state', 'com_ats.category.' . $item->catid) || Permissions::isManager($item->catid);
                        $hasInvitedUsers = $model->hasInvitedUsers($this->items, $item);

						$creator  = Permissions::getUser($item->created_by);
						$modifier = Permissions::getUser($item->modified_by);
						$assignee = ($item->assigned_to ?? 0) > 0 ? Permissions::getUser($item->assigned_to) : null;

						// index.php?option=com_categories&task=category.edit&id=14&extension=com_ats
						$item->cat_link = Route::_(sprintf("index.php?option=com_categories&extension=com_ats&task=category.edit&id=%u", $item->catid));
						?>
					<tr class="row<?= $i % 2; ?>">
						<?php // Checkbox ?>
						<td class="text-center">
							<?= HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
						</td>
						<?php // User ?>
						<td class="d-none d-md-table-cell">
							<?= LayoutHelper::render('akeeba.ats.common.user', [
								'user_id'    => $creator->id,
								'username'   => $creator->username,
								'name'       => $creator->name,
								'email'      => $creator->email,
								'showLink'   => true,
                                'hasInvited' => $hasInvitedUsers
							], JPATH_ADMINISTRATOR . '/components/com_ats/layout') ?>
						</td>
						<?php // Created / Last Reply ?>
						<td>
							<?= HTMLHelper::_('ats.date', $item->created) ?>
							<br/>
							<span class="text-info small">
								<strong><?= Text::_('COM_ATS_TICKETS_HEADING_MODIFIED') ?></strong>
								<?= HTMLHelper::_('ats.date', $item->modified) ?>, <?= $modifier->username ?>
							</span>
						</td>
						<?php // Title / Category, State, Assigned, Time ?>
						<th scope="row" class="has-context">
							<div>
								<?= LayoutHelper::render('akeeba.ats.common.status', [
									'item'  => $item,
									'class' => 'px-2 me-2'
								], JPATH_ADMINISTRATOR . '/components/com_ats/layout') ?>

								<?php if ($canEdit || $canEditOwn) : ?>
									<a href="<?= Route::_(sprintf("index.php?option=com_ats&task=ticket.edit&id=%u", (int) $item->id)); ?>"
									   title="<?= Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->title); ?>">
										<?php echo $this->escape($item->title); ?></a>
								<?php else : ?>
									<?php echo $this->escape($item->title); ?>
								<?php endif; ?>
								<div class="small py-1">
									<strong><?= Text::_('JCATEGORY') ?></strong>:
									<?php if ($canEdit): ?>
									<a href="<?= $item->cat_link ?>"
									   title="<?= Text::_('JACTION_EDIT'); ?> <?= $this->escape($item->cat_title) ?>"
									>
										<?= $this->escape($item->cat_title); ?>
									</a>
									<?php else: ?>
										<?= $this->escape($item->cat_title); ?>
									<?php endif; ?>
								</div>
								<?php if ($assignee): ?>
								<div class="small">
									<?= LayoutHelper::render('akeeba.ats.common.assignee', [
										'item'  => $item,
									], JPATH_ADMINISTRATOR . '/components/com_ats/layout') ?>
								</div>
								<?php endif; ?>
							</div>
						</th>
						<?php // Enabled ?>
						<td class="text-center">
							<?php echo HTMLHelper::_('jgrid.published', $item->enabled, $i, 'tickets.', $canChange, 'cb'); ?>
						</td>
						<?php // Private ?>
						<td class="text-center">
							<?php echo HTMLHelper::_('ats.publicToggle', $item->public, $i, $canChange); ?>
						</td>
						<?php if ($this->showTimeSpent): ?>
						<td class="text-end">
							<?= $this->timeSpentHumanReadable($item->timespent) ?>
						</td>
						<?php endif ?>
						<?php if (Multilanguage::isEnabled()) : ?>
						<?php // Language ?>
						<td class="w-10 d-none d-md-table-cell">
							<?php echo LayoutHelper::render('joomla.content.language', $item); ?>
						</td>
						<?php endif; ?>
						<?php // ID / Priority ?>
						<td class="d-none d-md-table-cell">
							<?php echo $item->id; ?>
							<?= LayoutHelper::render('akeeba.ats.common.priority_badge', [
								'item'  => $item,
								'showNormal' => true,
							], JPATH_ADMINISTRATOR . '/components/com_ats/layout') ?>
						</td>
					</tr>
					<?php endforeach ?>
					</tbody>
				</table>

				<?php // load the pagination. ?>
				<?php echo $this->pagination->getListFooter(); ?>

				<?php // Load the batch processing form. ?>
				<?php if ($user->authorise('core.create', 'com_ats')
					&& $user->authorise('core.edit', 'com_ats')
					&& $user->authorise('core.edit.state', 'com_ats')) : ?>
					<?php echo HTMLHelper::_(
						'bootstrap.renderModal',
						'collapseModal',
						[
							'title'  => Text::_('COM_ATS_TICKETS_BATCH_OPTIONS'),
							'footer' => $this->loadTemplate('batch_footer'),
						],
						$this->loadTemplate('batch_body')
					); ?>
				<?php endif; ?>
			<?php endif; ?>
				<input type="hidden" name="task" value="">
				<input type="hidden" name="boxchecked" value="0">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>
