<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Component\ATS\Site\Controller;

use Akeeba\Component\ATS\Site\Mixin\ControllerTicketStateFilterTrait;

defined('_JEXEC') or die;

class CategoryController extends CategoriesController
{
	use ControllerTicketStateFilterTrait;

	public function display($cachable = false, $urlparams = [])
	{
		$this->fixMissingStatusFilterInPost();

		// Migration from old menu items
		$catId = $this->app->getInput()->getInt('id', $this->app->getInput()->getInt('category'));
		$this->app->getInput()->set('id', $catId);

		return parent::display($cachable, $urlparams);
	}
}