<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

use Akeeba\Component\ATS\Administrator\Helper\Permissions;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Akeeba\Component\ATS\Site\View\Ticket\HtmlView $this */

// Nothing to display, stop here
if (!$this->canDo['ticket.invite'] && !$this->invited_users)
{
    return;
}

$bgLight = version_compare(JVERSION, '5.0.0', 'ge') ? 'bg-body-tertiary' : 'bg-light';
$my = Factory::getApplication()->getIdentity();
?>

<div class="border rounded-2 p-2 my-3 <?= $bgLight ?> d-flex flex-column ats-pseudotoolbar">
	<?php if ($this->canDo['ticket.invite']): ?>
		<form class="row row-cols-lg-auto align-items-center" style="display: inline-block"
			  action="<?= Route::_('index.php?option=com_ats&task=ticket.invite') ?>"
			  method="post"
		>
			<input type="hidden" name="id" value="<?= $this->item->id ?>">
			<input type="hidden" name="returnurl" value="<?= base64_encode(Uri::getInstance()->toString(['scheme', 'user', 'pass', 'host', 'port', 'path', 'query', 'fragment'])) ?>">
			<?= HTMLHelper::_('form.token') ?>

			<div class="input-group mb-3">
				<label class="visually-hidden" for="inlineFormInputGroupUsername"><?= Text::_('JGLOBAL_USERNAME') ?></label>
				<input type="text" class="form-control form-control-sm" name="invite_user" placeholder="<?= Text::_('JGLOBAL_USERNAME') ?>" aria-label="<?= Text::_('JGLOBAL_USERNAME') ?>">
				<button type="submit" class="btn btn-outline-primary">
					<span class="fa fa-user-plus" aria-hidden="true"></span>
					<span id="ats-edit-ticket-label"><?= Text::_('COM_ATS_TICKET_LBL_INVITE') ?></span>
				</button>
			</div>
		</form>
	<?php endif ?>
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5">
        <?php
            foreach ($this->invited_users as $user):
                $can_remove = false;

                // If I'm a manager, I can remove invited people
                if (Permissions::isManager($this->item->catid))
                {
                    $can_remove = true;
                }
                // I can always remove myself
                elseif ($user->id == $my->id)
                {
                    $can_remove = true;
                }
        ?>
			<div>
				<?php if ($can_remove): ?>
					<a id="ats-remove-invite" class="btn btn-sm btn-outline-danger me-2 hasTooltip"
					   href="<?= $this->actionUrl('tickets.removeinvite', ['userid' => $user->id]) ?>"
					   title="<?= Text::_('COM_ATS_TICKET_INVITE_REMOVE') ?>"
					>
						<span class="fa fa-trash" aria-hidden="true"></span>
						<span id="ats-remove-invite-label" class="visually-hidden"><?= Text::_('COM_ATS_TICKET_INVITE_REMOVE') ?></span>
					</a>
				<?php endif; ?>
				<span class="font-monospace"><?php echo $user->username ?></span>
			</div>
        <?php endforeach; ?>
    </div>
</div>