/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

"use strict";

window.addEventListener("DOMContentLoaded", function ()
{
    var options = Joomla.getOptions('atsGraphs');
    var url = options.ajaxUrl + '&since=' + encodeURIComponent(options.since) + '&' + encodeURIComponent(Joomla.getOptions('csrf.token', '')) + '=1';

    Joomla.request({
        url: url,
        method: 'GET',
        headers: { 'Content-Type': 'application/json' },
        perform: true,
        onSuccess: function (rawJson) {
            var response = JSON.parse(rawJson);

            if (!response.success)
            {
                Joomla.renderMessages({ error: [response.message] });

                return;
            }

            var data = response.data;
            var ticketPoints = [];
            var postPoints = [];

            for (var i = 0; i < data.length; i++)
            {
                var item = data[i];

                ticketPoints.push({
                    "x": item.date,
                    "y": item.tickets
                });

                postPoints.push({
                    "x": item.date,
                    "y": item.posts
                });
            }

            document.getElementById("akthrobber").style.display = "none";

            var chartOptions = {
                type:    "bar",
                data:    {
                    datasets: [
                        {
                            label:       "Posts",
                            data:        postPoints,
                            borderColor: "#F0AD4E",
                            fill:        false,
                            yAxisID:     "y-axis-posts",
                            type:        "line"
                        },
                        {
                            label:           "Tickets",
                            data:            ticketPoints,
                            backgroundColor: "#40B5B8",
                            fill:            true,
                            yAxisID:         "y-axis-tickets"
                        }
                    ]
                },
                options: {
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        x:                {
                            type:  "time",
                            time:  {
                                round:         "day",
                                tooltipFormat: "ll",
                                unit:          "day",
                                minUnit:       "day"
                            },
                            ticks: {
                                color: "#F0AD4E"
                            }
                        },
                        "y-axis-tickets": {
                            id:       "y-axis-tickets",
                            position: "left",
                            ticks:    {
                                color:       "#40B5B8",
                                beginAtZero: true
                            }
                        },
                        "y-axis-posts":   {
                            position: "right",
                            ticks:    {
                                color:       "#F0AD4E",
                                beginAtZero: true
                            },
                            grid:     {
                                drawOnChartArea: false
                            }
                        }
                    }
                }
            };

            var ticketsChart = new Chart(document.getElementById("akticketschartCanvas"), chartOptions);
        }
    });
});