/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

"use strict";

window.addEventListener("DOMContentLoaded", function ()
{
    [].slice.call(document.querySelectorAll(".atsTimespentFieldStartStop")).forEach(function (el)
    {
        el.addEventListener("click", function (e)
        {
            var elButton = e.target;
            var targetId = elButton.dataset.parent ?? null;

            if (!targetId)
            {
                return;
            }

            var elInput = document.getElementById(targetId);

            if (!elInput)
            {
                return;
            }

            var isStarted = (elButton.dataset.started ?? '0') * 1;
            var elapsed = (elButton.dataset.elapsed ?? '0') * 1;

            if (isStarted)
            {
                var timerId = (elButton.dataset.timerhandle ?? '0') * 1;

                if (timerId)
                {
                    window.clearInterval(timerId);
                }

                elInput.value = Math.round(100 * elapsed / 60) / 100;
                elInput.removeAttribute('disabled');
                elButton.innerText = Joomla.Text._('COM_ATS_POSTS_TIMESPENT_FIELD_START');
                elButton.classList.remove('btn-outline-primary');
                elButton.classList.add('btn-outline-secondary');
                elButton.dataset.started = '0';
                elInput.removeAttribute('data-timerhandle');

                return;
            }

            elInput.setAttribute("disabled", "disabled");
            elButton.innerText = Joomla.Text._('COM_ATS_POSTS_TIMESPENT_FIELD_STOP');
            elButton.classList.add("btn-outline-primary");
            elButton.classList.remove("btn-outline-secondary");
            elButton.dataset.started = "1";

            var timerStep = function ()
            {
                var elapsed = (elButton.dataset.elapsed ?? '0') * 1;
                elapsed += 1;
                elButton.dataset.elapsed = elapsed;
                elInput.value            = Math.round(100 * elapsed / 60) / 100;
            };
            var intervalId  = window.setInterval(timerStep, 1000);
            elButton.dataset.timerhandle = intervalId;
        });

        // Simulate click for auto–start timers
        var autostart = el.dataset.autostart ?? "0";

        if (autostart === '1')
        {
            if (typeof el.click === "function")
            {
                el.click();
            }
            else
            {
                var event = document.createEvent("Event");
                event.initEvent("click", true, true);
                el.dispatchEvent(event);
            }
        }
    });

});