/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

((document, Joomla) => {

	const copyToClipboardFallback = input => {
		input.focus();
		input.select();

		try
		{
			const copy = document.execCommand('copy');

			if (copy)
			{
				Joomla.renderMessages({
					message: [Joomla.Text._('COM_ATS_AUTHENTICATE_LBL_TOKEN_COPY_SUCCESS')]
				});
			}
			else
			{
				Joomla.renderMessages({
					error: [Joomla.Text._('COM_ATS_AUTHENTICATE_LBL_TOKEN_COPY_FAIL')]
				});
			}
		}
		catch (err)
		{
			Joomla.renderMessages({
				error: [err]
			});
		}
	};

	const copyToClipboard = () => {
		document
			.querySelectorAll('.token-copy')
			.forEach(
				(button) => {
					button.addEventListener(
						'click',
						({
							 currentTarget
						 }) => {
							const input = currentTarget.previousElementSibling;

							if (!navigator.clipboard)
							{
								copyToClipboardFallback(input);
								return;
							}

							navigator.clipboard.writeText(input.value).then(() => {
								Joomla.renderMessages({
									message: [Joomla.Text._('COM_ATS_AUTHENTICATE_LBL_TOKEN_COPY_SUCCESS')]
								});
							}, () => {
								Joomla.renderMessages({
									error: [Joomla.Text._('COM_ATS_AUTHENTICATE_LBL_TOKEN_COPY_FAIL')]
								});
							});
						}
					);
				}
			)
	};

	copyToClipboard();
})(document, Joomla);
