<?php
/**
 * @package   ats
 * @copyright Copyright (c)2011-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;

$value = $field->value;

if ($value == '')
{
	return;
}

/** @var \Joomla\Database\DatabaseDriver $db */
$db    = $this->getDatabase();
$value = (array) $value;
$query = (method_exists($db, 'createQuery') ? $db->createQuery() : $db->getQuery(true));
$sql   = $fieldParams->get('query', '');

$bindNames = $query->bindArray($value, ParameterType::STRING);

// Run the query with a having condition because it supports aliases
$query->setQuery($sql . ' HAVING ' . $db->quoteName('value') . ' IN (' . implode(',', $bindNames) . ')');

try
{
	$db->setQuery($query);
	$items = $db->loadObjectList();
}
catch (Exception $e)
{
	// If the query failed, we fetch all elements
	$db->setQuery($sql);
	$items = $db->loadObjectList();
}

$texts = array();

foreach ($items as $item)
{
	if (in_array($item->value, $value))
	{
		$texts[] = $item->text;
	}
}

echo htmlentities(implode(', ', $texts));
