<?php
/**
 * @package   admintoolswp
 * @copyright Copyright (c)2017-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU GPL version 3 or later
 */

defined('ADMINTOOLSINC') or die;

class AdminToolsFatalErrorHandler extends WP_Fatal_Error_Handler
{
	public static ?Throwable $exception = null;

	public static function getException(): ?Throwable
	{
		return self::$exception ?? null;
	}

	public static function setException(?Throwable $exception)
	{
		self::$exception = $exception;
	}

	public static function clearException()
	{
		self::$exception = null;
	}

	public static function error_get_last(): ?array
	{
		if (self::$exception)
		{
			return [
				'type'    => E_ERROR,
				'message' => self::$exception->getMessage(),
				'file'    => self::$exception->getFile(),
				'line'    => self::$exception->getLine(),
			];
		}

		return null;
	}

	protected function detect_error()
	{
		return self::error_get_last() ?? parent::detect_error();
	}
}