<?php
/**
 * @package   AkeebaSocialLogin
 * @copyright Copyright (c)2016-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\Plugin\Sociallogin\Auth0\Integration;

use Akeeba\Plugin\System\SocialLogin\Library\OAuth\OAuth2Client;
use Joomla\CMS\Application\CMSApplication;
use Joomla\Http\Http;
use Joomla\Input\Input;

class OAuth extends OAuth2Client
{
	/**
	 * Constructor.
	 *
	 * @param   array           $options      OAuth options array.
	 * @param   Http            $client       The HTTP client object.
	 * @param   Input           $input        The input object.
	 * @param   CMSApplication  $application  The application object.
	 */
	public function __construct($options, $client, $input, $application)
	{
		$this->application = $application;

		if (empty($options['domain']))
		{
			throw new \RuntimeException('Not configured', 500);
		}

		// Call the \Joomla\OAuth2\Client constructor to setup the object.
		parent::__construct($options, $client, $input, $application);
	}

	/**
	 * Method to get the current scope
	 *
	 * @return  string Comma separated list of permissions.
	 */
	public function getScope()
	{
		return $this->getOption('scope');
	}

	/**
	 * Method used to set permissions.
	 *
	 * @param   string  $scope  Comma separated list of permissions.
	 *
	 * @return  self  This object for method chaining
	 */
	public function setScope($scope)
	{
		$this->setOption('scope', $scope);

		return $this;
	}
}
